/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyToHTMLImageUtil
extends CopyToImageUtil {
    private HashMap<ImageFileFormat, Dimension> imageFormatToTileSizeMap = new HashMap(ImageFileFormat.VALUES.length);
    private String tileImageFileNameIndexDelimiter = "_";

    public CopyToHTMLImageUtil() {
        this.imageFormatToTileSizeMap.put(ImageFileFormat.GIF, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.BMP, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.JPG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.JPEG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.PNG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.SVG, new Dimension(0, 0));
    }

    @Override
    public DiagramGenerator copyToImage(DiagramEditPart diagramEP, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        Dimension dimension = (Dimension)MapModeUtil.getMapMode((IFigure)diagramEP.getFigure()).DPtoLP((Translatable)this.imageFormatToTileSizeMap.get(format));
        IPath destinationFolder = destination.removeLastSegments(1);
        String fileName = destination.removeFileExtension().lastSegment();
        Point tiles = this.exportImage(gen, diagramEP.getPrimaryEditParts(), destinationFolder, fileName, format, dimension.width, dimension.height, monitor);
        this.createHTMLFileForTiledImage(destination, fileName, format.getName().toLowerCase(), tiles.y, tiles.x);
        return gen;
    }

    @Override
    public void copyToImage(DiagramEditPart diagramEP, List selection, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        Dimension dimension = (Dimension)MapModeUtil.getMapMode((IFigure)diagramEP.getFigure()).DPtoLP((Translatable)this.imageFormatToTileSizeMap.get(format));
        IPath destinationFolder = destination.removeLastSegments(1);
        String fileName = destination.removeFileExtension().lastSegment();
        Point tiles = this.exportImage(gen, selection, destinationFolder, fileName, format, dimension.width, dimension.height, monitor);
        this.createHTMLFileForTiledImage(destination, fileName, format.getName().toLowerCase(), tiles.y, tiles.x);
    }

    private Point exportImage(DiagramGenerator gen, List editParts, IPath destinationFolder, String fileName, ImageFileFormat imageFormat, int logTileWidth, int logTileHeight, IProgressMonitor monitor) throws Error, CoreException {
        Rectangle diagramArea = gen.calculateImageRectangle(editParts);
        int rows = 1;
        int columns = 1;
        if (logTileWidth <= 0 || logTileHeight <= 0) {
            IPath imageFileDestination = new Path(destinationFolder.toString()).append(fileName).addFileExtension(imageFormat.getName().toLowerCase());
            this.copyToImage(gen, editParts, diagramArea, imageFileDestination, imageFormat, monitor);
        } else {
            columns = (int)Math.ceil((double)diagramArea.width / (double)logTileWidth);
            rows = (int)Math.ceil((double)diagramArea.height / (double)logTileHeight);
            int jobsToDo = 6 * columns * rows + 1;
            monitor.beginTask(DiagramUIMessages.CopyToHTMLImageTask_exportingToHTML, jobsToDo);
            int i = 0;
            while (i < rows) {
                int sourceY = i * logTileHeight + diagramArea.y;
                int sourceHeight = Math.min(logTileHeight, diagramArea.height - logTileHeight * i);
                int j = 0;
                while (j < columns) {
                    int sourceX = diagramArea.x + j * logTileWidth;
                    int sourceWidth = Math.min(logTileWidth, diagramArea.width - logTileWidth * j);
                    String tileFileName = String.valueOf(fileName) + this.getTileImageFileNameIndexDelimiter() + i + this.getTileImageFileNameIndexDelimiter() + j + "." + imageFormat.getName().toLowerCase();
                    IPath tilePath = new Path(destinationFolder.toOSString()).append(tileFileName);
                    monitor.subTask(String.valueOf(DiagramUIMessages.CopyToHTMLImageTask_generateImageFile) + tilePath);
                    this.copyToImage(gen, editParts, new Rectangle(sourceX, sourceY, sourceWidth, sourceHeight), tilePath, imageFormat, monitor);
                    ++j;
                }
                ++i;
            }
        }
        return new Point(columns, rows);
    }

    private IStatus createHTMLFileForTiledImage(IPath htmlFileLocation, String fileName, String fileExtension, int numRows, int numColumns) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(htmlFileLocation.toOSString()));
            out.write("<html>\n<body>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"RIGHT\">\n");
            if (numRows == 1 && numColumns == 1) {
                out.write("<tr>\n");
                out.write("\t<td><img src=\"");
                out.write(String.valueOf(fileName) + "." + fileExtension);
                out.write("\"></td>\n");
                out.write("</tr>\n");
            } else {
                int i = 0;
                while (i < numRows) {
                    out.write("<tr>\n");
                    int j = 0;
                    while (j < numColumns) {
                        out.write("\t<td><img src=\"");
                        out.write(String.valueOf(fileName) + this.getTileImageFileNameIndexDelimiter() + i + this.getTileImageFileNameIndexDelimiter() + j + "." + fileExtension);
                        out.write("\"></td>\n");
                        ++j;
                    }
                    out.write("</tr>\n");
                    ++i;
                }
            }
            out.write("</table>\n</body>\n</html>");
            out.close();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(htmlFileLocation);
            if (file != null) {
                file.refreshLocal(0, null);
                return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
            }
        }
        catch (IOException iOException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException coreException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getTileImageFileNameIndexDelimiter() {
        return this.tileImageFileNameIndexDelimiter;
    }

    public void setTileImageFileNameIndexDelimiter(String tileImageFileNameIndexDelimiter) {
        if (tileImageFileNameIndexDelimiter == null || tileImageFileNameIndexDelimiter.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.tileImageFileNameIndexDelimiter = tileImageFileNameIndexDelimiter;
    }

    public HashMap<ImageFileFormat, Dimension> getImageFormatToTileSizeMap() {
        return this.imageFormatToTileSizeMap;
    }
}

