/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal.wst;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.wst.IModuleVisitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;

public class ModuleTraverser {
    public static final String EAR_MODULE = "jst.ear";
    public static final String WEB_MODULE = "jst.web";
    public static final String UTILITY_MODULE = "jst.utility";
    public static final String CLASSPATH_COMPONENT_DEPENDENCY = "org.eclipse.jst.component.dependency";
    public static final String CLASSPATH_COMPONENT_NON_DEPENDENCY = "org.eclipse.jst.component.nondependency";

    public static void traverse(IModule module, IModuleVisitor visitor, IProgressMonitor monitor) throws CoreException {
        if (module == null || module.getModuleType() == null) {
            return;
        }
        String typeId = module.getModuleType().getId();
        IVirtualComponent component = ComponentCore.createComponent((IProject)module.getProject());
        if (component == null) {
            Trace.trace((byte)1, "Unable to create component for module " + module.getName());
            return;
        }
        if (EAR_MODULE.equals(typeId)) {
            ModuleTraverser.traverseEarComponent(component, visitor, monitor);
        } else if (WEB_MODULE.equals(typeId)) {
            ModuleTraverser.traverseWebComponent(component, visitor, monitor);
        }
    }

    private static void traverseEarComponent(IVirtualComponent component, IModuleVisitor visitor, IProgressMonitor monitor) throws CoreException {
        visitor.endVisitEarComponent(component);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void traverseWebComponent(IVirtualComponent component, IModuleVisitor visitor, IProgressMonitor monitor) throws CoreException {
        StructureEdit warStruct;
        block10: {
            block9: {
                visitor.visitWebComponent(component);
                IProject proj = component.getProject();
                warStruct = StructureEdit.getStructureEditForRead((IProject)proj);
                try {
                    WorkbenchComponent comp = warStruct.getComponent();
                    if (comp == null) {
                        Trace.trace((byte)2, "Error getting WorkbenchComponent from war project. IProject=\"" + proj + "\" StructureEdit=\"" + warStruct + "\" WorkbenchComponent=\"" + comp + "\"");
                        Object var13_6 = null;
                        break block9;
                    }
                    ModuleTraverser.traverseWebComponentLocalEntries(comp, visitor, monitor);
                    EList children = comp.getReferencedComponents();
                    Iterator itor = children.iterator();
                    while (itor.hasNext()) {
                        ReferencedComponent childRef = (ReferencedComponent)itor.next();
                        IPath rtFolder = childRef.getRuntimePath();
                        URI refHandle = childRef.getHandle();
                        if ("classpath".equals(refHandle.segment(0))) {
                            IPath refPath = ModuleTraverser.getResolvedPathForArchiveComponent(refHandle);
                            if (refPath == null) continue;
                            if (!refPath.isAbsolute()) {
                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(refPath);
                                refPath = file.getLocation();
                            }
                            visitor.visitArchiveComponent(rtFolder, refPath);
                            continue;
                        }
                        try {
                            WorkbenchComponent childCom = warStruct.findComponentByURI(refHandle);
                            if (childCom == null) continue;
                            ModuleTraverser.traverseDependentEntries(visitor, rtFolder, childCom, monitor);
                        }
                        catch (UnresolveableURIException e) {
                            TomcatPlugin.log(e);
                        }
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var13_7 = null;
                    warStruct.dispose();
                    throw throwable;
                }
            }
            warStruct.dispose();
            return;
        }
        Object var13_8 = null;
        warStruct.dispose();
        visitor.endVisitWebComponent(component);
    }

    private static void traverseWebComponentLocalEntries(WorkbenchComponent comp, IModuleVisitor visitor, IProgressMonitor monitor) throws CoreException {
        IProject warProject = StructureEdit.getContainingProject((WorkbenchComponent)comp);
        if (warProject == null || !warProject.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject project = JavaCore.create((IProject)warProject);
        EList res = comp.getResources();
        Iterator itorRes = res.iterator();
        while (itorRes.hasNext()) {
            ComponentResource childComp = (ComponentResource)itorRes.next();
            IClasspathEntry cpe = ModuleTraverser.getClasspathEntry(project, childComp.getSourcePath());
            if (cpe == null) continue;
            visitor.visitWebResource(childComp.getRuntimePath(), ModuleTraverser.getOSPath(warProject, project, cpe.getOutputLocation()));
        }
        Map classpathDeps = ModuleTraverser.getComponentClasspathDependencies(project, true);
        Iterator iterator = classpathDeps.keySet().iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            IClasspathAttribute attrib = (IClasspathAttribute)classpathDeps.get(entry);
            String rtFolder = attrib.getValue();
            if (rtFolder == null) {
                rtFolder = "/WEB-INF/lib";
            }
            IPath entryPath = entry.getPath();
            IResource entryRes = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (entryRes != null) {
                entryPath = entryRes.getLocation();
            }
            visitor.visitArchiveComponent((IPath)new Path(rtFolder), entryPath);
        }
    }

    private static void traverseDependentEntries(IModuleVisitor visitor, IPath runtimeFolder, WorkbenchComponent component, IProgressMonitor monitor) throws CoreException {
        IProject dependentProject = StructureEdit.getContainingProject((WorkbenchComponent)component);
        if (!dependentProject.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject project = JavaCore.create((IProject)dependentProject);
        String name = component.getName();
        EList res = component.getResources();
        Iterator itorRes = res.iterator();
        while (itorRes.hasNext()) {
            ComponentResource childComp = (ComponentResource)itorRes.next();
            IPath rtPath = childComp.getRuntimePath();
            IClasspathEntry cpe = ModuleTraverser.getClasspathEntry(project, childComp.getSourcePath());
            if (cpe == null) continue;
            visitor.visitDependentComponent(runtimeFolder.append(rtPath).append(String.valueOf(name) + ".jar"), ModuleTraverser.getOSPath(dependentProject, project, cpe.getOutputLocation()));
        }
        Map classpathDeps = ModuleTraverser.getComponentClasspathDependencies(project, false);
        Iterator iterator = classpathDeps.keySet().iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            IClasspathAttribute attrib = (IClasspathAttribute)classpathDeps.get(entry);
            String rtFolder = attrib.getValue();
            if (rtFolder == null) {
                rtFolder = "/WEB-INF/lib";
            }
            IPath entryPath = entry.getPath();
            IResource entryRes = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (entryRes != null) {
                entryPath = entryRes.getLocation();
            }
            visitor.visitArchiveComponent((IPath)new Path(rtFolder), entryPath);
        }
    }

    private static IClasspathEntry getClasspathEntry(IJavaProject project, IPath sourcePath) throws JavaModelException {
        sourcePath = project.getPath().append(sourcePath);
        IClasspathEntry[] cp = project.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (sourcePath.equals((Object)cp[i].getPath())) {
                return JavaCore.getResolvedClasspathEntry((IClasspathEntry)cp[i]);
            }
            ++i;
        }
        return null;
    }

    private static IPath getOSPath(IProject project, IJavaProject javaProject, IPath outputPath) throws JavaModelException {
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath).getLocation();
    }

    private static IPath getResolvedPathForArchiveComponent(URI uri) {
        String resourceType = uri.segment(1);
        URI contenturi = ModuleURIUtil.trimToRelativePath((URI)uri, (int)2);
        String contentName = contenturi.toString();
        if (resourceType.equals("lib")) {
            return Path.fromOSString((String)contentName);
        }
        if (resourceType.equals("var")) {
            String classpathVar = contenturi.segment(0);
            URI remainingPathuri = ModuleURIUtil.trimToRelativePath((URI)contenturi, (int)1);
            String remainingPath = remainingPathuri.toString();
            String[] classpathvars = JavaCore.getClasspathVariableNames();
            boolean found = false;
            int i = 0;
            while (i < classpathvars.length) {
                if (classpathVar.equals(classpathvars[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                IPath path = JavaCore.getClasspathVariable((String)classpathVar);
                URI finaluri = URI.createURI((String)(String.valueOf(path.toOSString()) + '/' + remainingPath));
                return Path.fromOSString((String)finaluri.toString());
            }
        }
        return null;
    }

    private static Map getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp) throws CoreException {
        Map referencedRawEntries = ModuleTraverser.getRawComponentClasspathDependencies(javaProject);
        HashMap<IClasspathEntry, IClasspathAttribute> validRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        Iterator i = referencedRawEntries.keySet().iterator();
        while (i.hasNext()) {
            IClasspathAttribute attrib;
            IClasspathEntry entry = (IClasspathEntry)i.next();
            if (!ModuleTraverser.isValid(entry, attrib = (IClasspathAttribute)referencedRawEntries.get(entry), isWebApp, javaProject.getProject())) continue;
            validRawEntries.put(entry, attrib);
        }
        if (validRawEntries.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
        int j = 0;
        while (j < entries.length) {
            pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            ++j;
        }
        HashMap<IClasspathEntry, IClasspathAttribute> referencedEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int j2 = 0;
        while (j2 < roots.length) {
            IPath pkgFragPath;
            IClasspathEntry resolvedEntry;
            IClasspathAttribute resolvedAttrib;
            IPackageFragmentRoot root = roots[j2];
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            IClasspathAttribute attrib = (IClasspathAttribute)validRawEntries.get(rawEntry);
            if (attrib != null && ((resolvedAttrib = ModuleTraverser.checkForComponentDependencyAttribute(resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath = root.getPath()))) == null || resolvedAttrib.getName().equals(CLASSPATH_COMPONENT_DEPENDENCY)) && ModuleTraverser.isValid(resolvedEntry, resolvedAttrib != null ? resolvedAttrib : attrib, isWebApp, javaProject.getProject())) {
                if (resolvedAttrib != null) {
                    attrib = resolvedAttrib;
                }
                referencedEntries.put(resolvedEntry, attrib);
            }
            ++j2;
        }
        return referencedEntries;
    }

    private static Map getRawComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        if (javaProject == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<IClasspathEntry, IClasspathAttribute> referencedRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IClasspathAttribute attrib = ModuleTraverser.checkForComponentDependencyAttribute(entry);
            if (attrib != null) {
                referencedRawEntries.put(entry, attrib);
            }
            ++i;
        }
        return referencedRawEntries;
    }

    private static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            String name = attribute.getName();
            if (name.equals(CLASSPATH_COMPONENT_DEPENDENCY) || name.equals(CLASSPATH_COMPONENT_NON_DEPENDENCY)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    private static boolean isValid(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project) {
        int kind = entry.getEntryKind();
        if (kind == 1) {
            IPath entryPath;
            IPath entryLocation = entryPath = entry.getPath();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (resource != null) {
                entryLocation = resource.getLocation();
            }
            if (entryLocation.toFile().isDirectory()) {
                return false;
            }
        } else if (kind == 2 || kind == 3) {
            return false;
        }
        String runtimePath = ModuleTraverser.getRuntimePath(attrib, isWebApp);
        return !(!isWebApp ? !entry.isExported() || !runtimePath.equals("../") : runtimePath != null && !runtimePath.equals("/WEB-INF/lib") && !runtimePath.equals("/WEB-INF/classes") && !runtimePath.equals("../"));
    }

    private static String getRuntimePath(IClasspathAttribute attrib, boolean isWebApp) {
        if (attrib != null && !attrib.getName().equals(CLASSPATH_COMPONENT_DEPENDENCY)) {
            return null;
        }
        if (attrib == null || attrib.getValue() == null || attrib.getValue().length() == 0) {
            return isWebApp ? "/WEB-INF/lib" : "../";
        }
        return attrib.getValue();
    }
}

