/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;

abstract class SingleChildResultSetNode
extends FromTable {
    ResultSetNode childResult;
    protected boolean hasTrulyTheBestAccessPath;

    SingleChildResultSetNode() {
    }

    public void init(Object object, Object object2) {
        super.init(null, object2);
        this.childResult = (ResultSetNode)object;
        if (this.childResult.getReferencedTableMap() != null) {
            this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        }
    }

    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    public ResultSetNode getChildResult() {
        return this.childResult;
    }

    void setChildResult(ResultSetNode resultSetNode) {
        this.childResult = resultSetNode;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).pullOptPredicates(optimizablePredicateList);
        }
    }

    public boolean forUpdate() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).forUpdate();
        }
        return super.forUpdate();
    }

    public void initAccessPaths(Optimizer optimizer) {
        super.initAccessPaths(optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).initAccessPaths(optimizer);
        }
    }

    public void printSubNodes(int n) {
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.childResult.referencesTarget(string, bl);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.childResult.referencesSessionSchema();
    }

    public void setLevel(int n) {
        super.setLevel(n);
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).setLevel(n);
        }
    }

    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return this.childResult.subqueryReferencesTarget(string, bl);
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(n, groupByList, fromList);
        this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        return this;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.childResult = this.childResult.addNewPredicate(predicate);
        return this;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicateList, d);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        this.childResult = this.childResult.modifyAccessPaths();
        return this;
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        this.childResult = this.childResult.changeAccessPath();
        return this;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.childResult.getFromTableByName(string, string2, bl);
    }

    void decrementLevel(int n) {
        super.decrementLevel(n);
        this.childResult.decrementLevel(n);
    }

    public int updateTargetLockMode() {
        return this.childResult.updateTargetLockMode();
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, Vector vector) throws StandardException {
        return this.childResult.isOrderedOn(columnReferenceArray, bl, vector);
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.childResult.isOneRowResultSet();
    }

    public boolean isNotExists() {
        return this.childResult.isNotExists();
    }

    protected boolean reflectionNeededForProjection() {
        return !this.resultColumns.allExpressionsAreColumns(this.childResult);
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        this.childResult.replaceDefaults(tableDescriptor, resultColumnList);
    }

    void markOrderingDependent() {
        this.childResult.markOrderingDependent();
    }

    public CostEstimate getFinalCostEstimate() {
        if (this.costEstimate == null) {
            return this.childResult.getFinalCostEstimate();
        }
        return this.costEstimate;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        if (visitor.skipChildren(this)) {
            return visitor.visit(this);
        }
        Visitable visitable = super.accept(visitor);
        if (this.childResult != null && !visitor.stopTraversal()) {
            this.childResult = (ResultSetNode)this.childResult.accept(visitor);
        }
        return visitable;
    }
}

