/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.IJpaEObject;
import org.eclipse.jpt.core.internal.IJpaFactory;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaEObject
extends EObjectImpl
implements IJpaEObject {
    private static final Map<Class<? extends JpaEObject>, Set<Integer>> insignificantFeatureIdSets = new Hashtable<Class<? extends JpaEObject>, Set<Integer>>();

    protected JpaEObject() {
    }

    protected EClass eStaticClass() {
        return JpaCorePackage.Literals.JPA_EOBJECT;
    }

    @Override
    public IJpaProject getJpaProject() {
        IJpaEObject container = (IJpaEObject)this.eContainer();
        return container == null ? null : container.getJpaProject();
    }

    @Override
    public IResource getResource() {
        return this.getJpaProject().getProject();
    }

    @Override
    public IJpaPlatform jpaPlatform() {
        return this.getJpaProject().getPlatform();
    }

    @Override
    public IJpaFactory jpaFactory() {
        return this.jpaPlatform().getJpaFactory();
    }

    public ConnectionProfile connectionProfile() {
        return this.getJpaProject().connectionProfile();
    }

    public Database database() {
        return this.connectionProfile().getDatabase();
    }

    public boolean isConnected() {
        ConnectionProfile cp = this.connectionProfile();
        return cp != null && cp.isConnected();
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch()) {
            super.eNotify(notification);
            this.featureChanged(notification.getFeatureID(this.getClass()));
        }
    }

    protected void featureChanged(int featureId) {
        IJpaProject project;
        if (this.featureIsSignificant(featureId) && (project = this.getJpaProject()) != null) {
            project.resynch();
        }
    }

    protected boolean featureIsSignificant(int featureId) {
        return !this.featureIsInsignificant(featureId);
    }

    protected boolean featureIsInsignificant(int featureId) {
        return this.insignificantFeatureIds().contains(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> insignificantFeatureIds() {
        Map<Class<? extends JpaEObject>, Set<Integer>> map = insignificantFeatureIdSets;
        synchronized (map) {
            Set<Integer> insignificantFeatureIds = insignificantFeatureIdSets.get(this.getClass());
            if (insignificantFeatureIds == null) {
                insignificantFeatureIds = new HashSet<Integer>();
                this.addInsignificantFeatureIdsTo(insignificantFeatureIds);
                insignificantFeatureIdSets.put(this.getClass(), insignificantFeatureIds);
            }
            return insignificantFeatureIds;
        }
    }

    protected void addInsignificantFeatureIdsTo(Set<Integer> insignificantFeatureIds) {
    }
}

