/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.mappings.IJavaMappedSuperclass;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.internal.mappings.IMappedSuperclass;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMappedSuperclass
extends JavaTypeMapping
implements IJavaMappedSuperclass {
    protected static final String ID_CLASS_EDEFAULT = null;
    protected String idClass = ID_CLASS_EDEFAULT;
    private final AnnotationAdapter idClassAnnotationAdapter;
    private final AnnotationElementAdapter<String> idClassValueAdapter;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.MappedSuperclass");
    public static final DeclarationAnnotationAdapter ID_CLASS_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.IdClass");
    private static final DeclarationAnnotationElementAdapter<String> ID_CLASS_VALUE_ADAPTER = JavaMappedSuperclass.buildIdClassValueAdapter();

    protected JavaMappedSuperclass() {
        throw new UnsupportedOperationException("Use JavaMappedSuperclass(Type) instead");
    }

    protected JavaMappedSuperclass(Type type) {
        super(type);
        this.idClassAnnotationAdapter = new MemberAnnotationAdapter(this.getType(), ID_CLASS_ADAPTER);
        this.idClassValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(this.getType(), ID_CLASS_VALUE_ADAPTER);
    }

    @Override
    public DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return DECLARATION_ANNOTATION_ADAPTER;
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IMappedSuperclass.class)) {
            case 2: {
                String newIdClass = (String)notification.getNewValue();
                if (newIdClass == null) {
                    this.idClassAnnotationAdapter.removeAnnotation();
                    break;
                }
                this.idClassValueAdapter.setValue(newIdClass);
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_MAPPED_SUPERCLASS;
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldIdClass, (Object)this.idClass));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getIdClass();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setIdClass((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setIdClass(ID_CLASS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return ID_CLASS_EDEFAULT == null ? this.idClass != null : !ID_CLASS_EDEFAULT.equals(this.idClass);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IMappedSuperclass.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == IJavaMappedSuperclass.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IMappedSuperclass.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == IJavaMappedSuperclass.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (idClass: ");
        result.append(this.idClass);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getKey() {
        return "mappedSuperclass";
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return this.namesOf(this.overridableAttributes());
    }

    private Iterator<IPersistentAttribute> overridableAttributes() {
        return new FilteringIterator<IPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(Object o) {
                return ((IPersistentAttribute)o).isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return this.namesOf(this.overridableAssociations());
    }

    private Iterator<IPersistentAttribute> overridableAssociations() {
        return new FilteringIterator<IPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(Object o) {
                return ((IPersistentAttribute)o).isOverridableAssociation();
            }
        };
    }

    private Iterator<String> namesOf(Iterator<IPersistentAttribute> attributes) {
        return new TransformationIterator<IPersistentAttribute, String>(attributes){

            protected String transform(IPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateIdClassFromJava(astRoot);
    }

    private void updateIdClassFromJava(CompilationUnit astRoot) {
        if (this.idClassAnnotationAdapter.getAnnotation(astRoot) == null) {
            this.setIdClass(null);
        } else {
            this.setIdClass(this.idClassValueAdapter.getValue(astRoot));
        }
    }

    private static DeclarationAnnotationElementAdapter<String> buildIdClassValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<String>(ID_CLASS_ADAPTER, "value", false, SimpleTypeStringExpressionConverter.instance());
    }
}

