/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmResource;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmArtifactEdit;
import org.eclipse.jpt.core.internal.emfutility.ComponentUtilities;

public class OrmXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    private static final OrmXmlJpaFileContentProvider INSTANCE = new OrmXmlJpaFileContentProvider();

    public static IJpaFileContentProvider instance() {
        return INSTANCE;
    }

    private OrmXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IJpaFile jpaFile) {
        IFile resourceFile = jpaFile.getFile();
        IPath deployPath = ComponentUtilities.computeDeployPath(resourceFile);
        OrmArtifactEdit artifactEdit = OrmArtifactEdit.getArtifactEditForWrite(resourceFile.getProject(), deployPath.toString());
        OrmResource resource = artifactEdit.getOrmResource();
        XmlRootContentNode root = OrmFactory.eINSTANCE.createXmlRootContentNode();
        if (resourceFile.equals((Object)resource.getFile())) {
            root.setArtifactEdit(artifactEdit);
            root.setEntityMappings(resource.getEntityMappings());
            resource.eAdapters().add((Object)this.buildRootNodeListener(resourceFile, root));
        } else {
            artifactEdit.dispose();
        }
        jpaFile.setContent(root);
        return root;
    }

    private Adapter buildRootNodeListener(IFile resourceFile, XmlRootContentNode root) {
        return new RootAdapter(resourceFile, root);
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.orm";
    }

    private class RootAdapter
    extends AdapterImpl {
        final IFile resourceFile;
        final XmlRootContentNode rootContentNode;

        RootAdapter(IFile resourceFile, XmlRootContentNode rootContentNode) {
            this.resourceFile = resourceFile;
            this.rootContentNode = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2 && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
                OrmResource resource = (OrmResource)notification.getNotifier();
                this.rootContentNode.setEntityMappings(resource.getEntityMappings());
            }
        }
    }
}

