/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.core.internal.emfutility.ComponentUtilities;

public class PersistenceXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    private static final PersistenceXmlJpaFileContentProvider INSTANCE = new PersistenceXmlJpaFileContentProvider();

    public static IJpaFileContentProvider instance() {
        return INSTANCE;
    }

    private PersistenceXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IJpaFile jpaFile) {
        IFile resourceFile = jpaFile.getFile();
        IPath deployPath = ComponentUtilities.computeDeployPath(resourceFile);
        PersistenceArtifactEdit artifactEdit = PersistenceArtifactEdit.getArtifactEditForWrite(resourceFile.getProject(), deployPath.toString());
        PersistenceResource resource = artifactEdit.getPersistenceResource();
        PersistenceXmlRootContentNode root = PersistenceFactory.eINSTANCE.createPersistenceXmlRootContentNode();
        if (resourceFile.equals((Object)resource.getFile())) {
            root.setArtifactEdit(artifactEdit);
            root.setPersistence(resource.getPersistence());
            resource.eAdapters().add((Object)this.buildRootNodeListener(resourceFile, root));
        } else {
            artifactEdit.dispose();
        }
        jpaFile.setContent(root);
        return root;
    }

    private Adapter buildRootNodeListener(IFile resourceFile, PersistenceXmlRootContentNode rootContentNode) {
        return new RootAdapter(resourceFile, rootContentNode);
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.persistence";
    }

    private class RootAdapter
    extends AdapterImpl {
        final IFile resourceFile;
        final PersistenceXmlRootContentNode rootContentNode;

        RootAdapter(IFile resourceFile, PersistenceXmlRootContentNode rootContentNode) {
            this.resourceFile = resourceFile;
            this.rootContentNode = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2 && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
                PersistenceResource resource = (PersistenceResource)((Object)notification.getNotifier());
                this.rootContentNode.setPersistence(resource.getPersistence());
            }
        }
    }
}

