/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JpaFacetDataModelProvider
extends FacetInstallDataModelProvider
implements IJpaFacetDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJpaFacetDataModelProperties.PLATFORM_ID");
        propertyNames.add("IJpaFacetDataModelProperties.CONNECTION");
        propertyNames.add("IJpaFacetDataModelProperties.RUNTIME");
        propertyNames.add("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        propertyNames.add("IJpaFacetDataModelProperties.JPA_LIBRARY");
        propertyNames.add("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        propertyNames.add("IJpaFacetDataModelProperties.CREATE_ORM_XML");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetDataModelProperties.FACET_ID".equals(propertyName)) {
            return "jpt.jpa";
        }
        if ("IJpaFacetDataModelProperties.PLATFORM_ID".equals(propertyName)) {
            return "generic";
        }
        if ("IJpaFacetDataModelProperties.CONNECTION".equals(propertyName)) {
            return "";
        }
        if ("IJpaFacetDataModelProperties.RUNTIME".equals(propertyName)) {
            return null;
        }
        if ("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION".equals(propertyName)) {
            return this.runtimeSupportsEjb30(this.getRuntime());
        }
        if ("IJpaFacetDataModelProperties.JPA_LIBRARY".equals(propertyName)) {
            return JptCorePlugin.getPlugin().getPluginPreferences().getString("defaultJpaLib");
        }
        if ("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES".equals(propertyName)) {
            return this.runtimeSupportsEjb30(this.getRuntime());
        }
        if ("IJpaFacetDataModelProperties.CREATE_ORM_XML".equals(propertyName)) {
            return true;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if ("IJpaFacetDataModelProperties.RUNTIME".equals(propertyName)) {
            this.model.notifyPropertyChange("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", 2);
            this.model.notifyPropertyChange("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", 2);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IJpaFacetDataModelProperties.JPA_LIBRARY".equals(propertyName)) {
            Object[] libraries = JavaCore.getUserLibraryNames();
            Arrays.sort(libraries);
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[libraries.length + 1];
            descriptors[0] = new DataModelPropertyDescriptor((Object)"", WTPCommonPlugin.getResourceString((String)"44", null));
            int i = 1;
            Object[] objectArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                Object library = objectArray[n2];
                descriptors[i++] = new DataModelPropertyDescriptor(library, (String)library);
                ++n2;
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String name) {
        if ("IJpaFacetDataModelProperties.PLATFORM_ID".equals(name)) {
            return this.validatePlatform(this.getStringProperty(name));
        }
        if ("IJpaFacetDataModelProperties.CONNECTION".equals(name)) {
            return this.validateConnection(this.getStringProperty(name));
        }
        if ("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION".equals(name) || "IJpaFacetDataModelProperties.JPA_LIBRARY".equals(name)) {
            return this.validateJpaLibrary();
        }
        if ("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES".equals(name)) {
            return this.validatePersistentClassManagement();
        }
        return super.validate(name);
    }

    private IRuntime getRuntime() {
        return (IRuntime)this.getProperty("IJpaFacetDataModelProperties.RUNTIME");
    }

    private boolean runtimeSupportsEjb30(IRuntime runtime) {
        IProjectFacetVersion ejb30 = ProjectFacetsManager.getProjectFacet((String)"jst.ejb").getVersion("3.0");
        return runtime == null ? false : runtime.supports(ejb30);
    }

    private IStatus validatePlatform(String platformId) {
        if (platformId == null || platformId.equals("")) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_PLATFORM_NOT_SPECIFIED);
        }
        return OK_STATUS;
    }

    private IStatus validateConnection(String connectionName) {
        if (connectionName == null || connectionName.equals("") || !ConnectionProfileRepository.instance().profileNamed(connectionName).isConnected()) {
            return new Status(1, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED);
        }
        return OK_STATUS;
    }

    private IStatus validateJpaLibrary() {
        if (this.getBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            IRuntime runtime = this.getRuntime();
            if (runtime == null) {
                return new Status(2, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_RUNTIME_NOT_SPECIFIED);
            }
            if (!this.runtimeSupportsEjb30(runtime)) {
                return new Status(2, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_RUNTIME_DOES_NOT_SUPPORT_EJB_30);
            }
        } else if (StringTools.stringIsEmpty((String)this.getStringProperty("IJpaFacetDataModelProperties.JPA_LIBRARY"))) {
            return new Status(2, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_LIBRARY_NOT_SPECIFIED);
        }
        return OK_STATUS;
    }

    private IStatus validatePersistentClassManagement() {
        return OK_STATUS;
    }
}

