/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.jpt.core.internal.JpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.osgi.service.prefs.BackingStoreException;

public class JpaFacetUtils {
    private static QualifiedName CONNECTION_KEY = new QualifiedName("org.eclipse.jpt.core", "org.eclipse.jpt.core.dataSource.connectionName");

    private JpaFacetUtils() {
    }

    public static String getPlatform(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jpt.core");
        String platformId = prefs.get("org.eclipse.jpt.core.platform", null);
        if (platformId == null) {
            try {
                JpaFacetUtils.setPlatform(project, "generic");
            }
            catch (CoreException coreException) {}
            return "generic";
        }
        return platformId;
    }

    public static void setPlatform(IProject project, String jpaPlatformId) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jpt.core");
        JpaProject jpaProject = (JpaProject)JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new IllegalArgumentException(project.getName());
        }
        if (JpaPlatformRegistry.instance().jpaPlatform(jpaPlatformId) == null) {
            throw new IllegalArgumentException(jpaPlatformId);
        }
        jpaProject.setPlatform(jpaPlatformId);
        prefs.put("org.eclipse.jpt.core.platform", jpaPlatformId);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            JptCorePlugin.log(e);
        }
    }

    public static String getConnectionName(IProject project) {
        try {
            return project.getPersistentProperty(CONNECTION_KEY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setConnectionName(IProject project, String connectionName) throws CoreException {
        JpaProject jpaProject = (JpaProject)JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new IllegalArgumentException(project.getName());
        }
        jpaProject.setDataSource(connectionName);
        project.setPersistentProperty(CONNECTION_KEY, connectionName);
    }

    public static boolean getDiscoverAnnotatedClasses(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jpt.core");
        return prefs.getBoolean("org.eclipse.jpt.core.discoverAnnotatedClasses", false);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jpt.core");
        JpaProject jpaProject = (JpaProject)JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new IllegalArgumentException(project.getName());
        }
        jpaProject.setDiscoverAnnotatedClasses(discoverAnnotatedClasses);
        prefs.putBoolean("org.eclipse.jpt.core.discoverAnnotatedClasses", discoverAnnotatedClasses);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            JptCorePlugin.log(e);
        }
    }
}

