/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.core.internal.IJpaFactory;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.IDefaultJavaAttributeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.JavaJpaFileContentProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasicProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddableProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbedded;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddedId;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddedIdProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbeddedProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEntity;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEntityProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaId;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaIdProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToMany;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToManyProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToOne;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaManyToOneProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaMappedSuperclass;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaNullAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaNullTypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToMany;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToManyProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToOne;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToOneProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTransient;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTransientProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaVersion;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaVersionProvider;
import org.eclipse.jpt.core.internal.content.orm.OrmXmlJpaFileContentProvider;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlJpaFileContentProvider;
import org.eclipse.jpt.core.internal.platform.BaseJpaProjectContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaBasicContext;
import org.eclipse.jpt.core.internal.platform.JavaEmbeddableContext;
import org.eclipse.jpt.core.internal.platform.JavaEmbeddedContext;
import org.eclipse.jpt.core.internal.platform.JavaEmbeddedIdContext;
import org.eclipse.jpt.core.internal.platform.JavaEntityContext;
import org.eclipse.jpt.core.internal.platform.JavaIdContext;
import org.eclipse.jpt.core.internal.platform.JavaManyToManyContext;
import org.eclipse.jpt.core.internal.platform.JavaManyToOneContext;
import org.eclipse.jpt.core.internal.platform.JavaMappedSuperclassContext;
import org.eclipse.jpt.core.internal.platform.JavaNullAttributeMappingContext;
import org.eclipse.jpt.core.internal.platform.JavaNullTypeMappingContext;
import org.eclipse.jpt.core.internal.platform.JavaOneToManyContext;
import org.eclipse.jpt.core.internal.platform.JavaOneToOneContext;
import org.eclipse.jpt.core.internal.platform.JavaTransientContext;
import org.eclipse.jpt.core.internal.platform.JavaVersionContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatform
implements IJpaPlatform {
    public static final String DEFAULT_TABLE_SCHEMA_KEY = "table.schema";
    public static final String DEFAULT_TABLE_CATALOG_KEY = "table.catalog";
    public static final String DEFAULT_TABLE_NAME_KEY = "table.name";
    public static final String DEFAULT_ACCESS_KEY = "access";
    public static final String DEFAULT_ENTITY_NAME_KEY = "entity.name";
    public static final String DEFAULT_COLUMN_TABLE_KEY = "column.table";
    public static final String DEFAULT_COLUMN_NAME_KEY = "column.name";
    public static final String DEFAULT_JOIN_TABLE_NAME_KEY = "joinTable.name";
    public static final String DEFAULT_TARGET_ENTITY_KEY = "oneToMany.targetEntity";
    public static final String DEFAULT_JOIN_COLUMN_TABLE_KEY = "joinColumn.table";
    public static final String DEFAULT_JOIN_COLUMN_NAME_KEY = "joinColumn.name";
    public static final String DEFAULT_JOIN_COLUMN_REFERENCED_COLUMN_NAME_KEY = "joinColumn.referencedColumnName";
    public static final String DEFAULT_TABLE_GENERATOR_SCHEMA_KEY = "tableGenerator.schema";
    private String id;
    protected IJpaProject project;
    private Collection<IJpaFileContentProvider> contentProviders;
    private Collection<IJavaAttributeMappingProvider> javaAttributeMappingProviders;
    private List<IDefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders;
    private Collection<IJavaTypeMappingProvider> javaTypeMappingProviders;
    private IJpaFactory jpaFactory = this.createJpaFactory();
    private IContext context;

    protected BaseJpaPlatform() {
    }

    protected abstract IJpaFactory createJpaFactory();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String theId) {
        this.id = theId;
    }

    @Override
    public IJpaProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IJpaProject jpaProject) {
        this.project = jpaProject;
    }

    @Override
    public IJpaFactory getJpaFactory() {
        return this.jpaFactory;
    }

    @Override
    public boolean containsPersistenceUnitNamed(String name) {
        return ((BaseJpaProjectContext)this.context).containsPersistenceUnitNamed(name);
    }

    @Override
    public PersistenceUnit persistenceUnitNamed(String name) {
        return ((BaseJpaProjectContext)this.context).persistenceUnitNamed(name);
    }

    @Override
    public Iterator<PersistenceUnit> persistenceUnits() {
        return ((BaseJpaProjectContext)this.context).persistenceUnits();
    }

    @Override
    public int persistenceUnitSize() {
        return ((BaseJpaProjectContext)this.context).persistenceUnitContextsSize();
    }

    @Override
    public Iterator<IPersistentType> persistentTypes(String persistenceUnitName) {
        PersistenceUnitContext puContext = ((BaseJpaProjectContext)this.context).persistenceUnitContext(persistenceUnitName);
        if (puContext == null) {
            return EmptyIterator.instance();
        }
        return puContext.persistentTypes();
    }

    @Override
    public Iterator<IJpaFileContentProvider> jpaFileContentProviders() {
        if (this.contentProviders == null) {
            this.contentProviders = new ArrayList<IJpaFileContentProvider>();
            this.addJpaFileContentProvidersTo(this.contentProviders);
        }
        return new CloneIterator(this.contentProviders);
    }

    @Override
    public IJpaFileContentProvider fileContentProvider(String contentTypeId) {
        Iterator<IJpaFileContentProvider> i = this.jpaFileContentProviders();
        while (i.hasNext()) {
            IJpaFileContentProvider provider = i.next();
            if (!provider.contentType().equals(contentTypeId)) continue;
            return provider;
        }
        return null;
    }

    protected void addJpaFileContentProvidersTo(Collection<IJpaFileContentProvider> providers) {
        providers.add(PersistenceXmlJpaFileContentProvider.instance());
        providers.add(JavaJpaFileContentProvider.instance());
        providers.add(OrmXmlJpaFileContentProvider.instance());
    }

    @Override
    public Iterator<IJavaTypeMappingProvider> javaTypeMappingProviders() {
        if (this.javaTypeMappingProviders == null) {
            this.javaTypeMappingProviders = new ArrayList<IJavaTypeMappingProvider>();
            this.addJavaTypeMappingProvidersTo(this.javaTypeMappingProviders);
        }
        return new CloneIterator(this.javaTypeMappingProviders);
    }

    protected void addJavaTypeMappingProvidersTo(Collection<IJavaTypeMappingProvider> providers) {
        providers.add(JavaEntityProvider.instance());
        providers.add(JavaMappedSuperclassProvider.instance());
        providers.add(JavaEmbeddableProvider.instance());
    }

    @Override
    public IJavaTypeMappingProvider javaTypeMappingProvider(String typeMappingKey) {
        Iterator<IJavaTypeMappingProvider> i = this.javaTypeMappingProviders();
        while (i.hasNext()) {
            IJavaTypeMappingProvider provider = i.next();
            if (provider.key() != typeMappingKey) continue;
            return provider;
        }
        return null;
    }

    @Override
    public Iterator<IJavaAttributeMappingProvider> javaAttributeMappingProviders() {
        if (this.javaAttributeMappingProviders == null) {
            this.javaAttributeMappingProviders = new ArrayList<IJavaAttributeMappingProvider>();
            this.addJavaAttributeMappingProvidersTo(this.javaAttributeMappingProviders);
        }
        return new CloneIterator(this.javaAttributeMappingProviders);
    }

    protected void addJavaAttributeMappingProvidersTo(Collection<IJavaAttributeMappingProvider> providers) {
        providers.add(JavaBasicProvider.instance());
        providers.add(JavaIdProvider.instance());
        providers.add(JavaTransientProvider.instance());
        providers.add(JavaOneToManyProvider.instance());
        providers.add(JavaManyToOneProvider.instance());
        providers.add(JavaManyToManyProvider.instance());
        providers.add(JavaOneToOneProvider.instance());
        providers.add(JavaEmbeddedProvider.instance());
        providers.add(JavaEmbeddedIdProvider.instance());
        providers.add(JavaVersionProvider.instance());
    }

    @Override
    public IJavaAttributeMappingProvider javaAttributeMappingProvider(String attributeMappingKey) {
        Iterator<IJavaAttributeMappingProvider> i = this.javaAttributeMappingProviders();
        while (i.hasNext()) {
            IJavaAttributeMappingProvider provider = i.next();
            if (provider.key() != attributeMappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported java attribute mapping key: " + attributeMappingKey);
    }

    @Override
    public ListIterator<IDefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders() {
        if (this.defaultJavaAttributeMappingProviders == null) {
            this.defaultJavaAttributeMappingProviders = new ArrayList<IDefaultJavaAttributeMappingProvider>();
            this.addDefaultAttributeMappingProvidersTo(this.defaultJavaAttributeMappingProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingProviders);
    }

    protected void addDefaultAttributeMappingProvidersTo(List<IDefaultJavaAttributeMappingProvider> providers) {
        providers.add(JavaEmbeddedProvider.instance());
        providers.add(JavaBasicProvider.instance());
    }

    @Override
    public IContext buildProjectContext() {
        this.context = new BaseJpaProjectContext(this.getProject());
        return this.context;
    }

    @Override
    public Iterator<IJpaFile> validPersistenceXmlFiles() {
        return ((BaseJpaProjectContext)this.context).validPersistenceXmlFiles();
    }

    @Override
    public IContext buildJavaTypeContext(IContext parentContext, IJavaTypeMapping typeMapping) {
        String key = typeMapping.getKey();
        if (key == "entity") {
            return new JavaEntityContext(parentContext, (JavaEntity)typeMapping);
        }
        if (key == "embeddable") {
            return new JavaEmbeddableContext(parentContext, (JavaEmbeddable)typeMapping);
        }
        if (key == "mappedSuperclass") {
            return new JavaMappedSuperclassContext(parentContext, (JavaMappedSuperclass)typeMapping);
        }
        if (key == null) {
            return new JavaNullTypeMappingContext(parentContext, (JavaNullTypeMapping)typeMapping);
        }
        throw new IllegalArgumentException(typeMapping.toString());
    }

    @Override
    public IContext buildJavaAttributeContext(IContext parentContext, IJavaAttributeMapping attributeMapping) {
        String key = attributeMapping.getKey();
        if (key == "basic") {
            return new JavaBasicContext(parentContext, (JavaBasic)attributeMapping);
        }
        if (key == "id") {
            return new JavaIdContext(parentContext, (JavaId)attributeMapping);
        }
        if (key == "version") {
            return new JavaVersionContext(parentContext, (JavaVersion)attributeMapping);
        }
        if (key == "embedded") {
            return new JavaEmbeddedContext(parentContext, (JavaEmbedded)attributeMapping);
        }
        if (key == "embeddedId") {
            return new JavaEmbeddedIdContext(parentContext, (JavaEmbeddedId)attributeMapping);
        }
        if (key == "oneToOne") {
            return new JavaOneToOneContext(parentContext, (JavaOneToOne)attributeMapping);
        }
        if (key == "oneToMany") {
            return new JavaOneToManyContext(parentContext, (JavaOneToMany)attributeMapping);
        }
        if (key == "manyToOne") {
            return new JavaManyToOneContext(parentContext, (JavaManyToOne)attributeMapping);
        }
        if (key == "manyToMany") {
            return new JavaManyToManyContext(parentContext, (JavaManyToMany)attributeMapping);
        }
        if (key == "transient") {
            return new JavaTransientContext(parentContext, (JavaTransient)attributeMapping);
        }
        if (key == null) {
            return new JavaNullAttributeMappingContext(parentContext, (JavaNullAttributeMapping)attributeMapping);
        }
        throw new IllegalArgumentException(attributeMapping.toString());
    }

    @Override
    public void resynch(IContext contextHierarchy, IProgressMonitor monitor) {
        ((BaseJpaProjectContext)contextHierarchy).refreshDefaults(monitor);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        BaseJpaProjectContext context = (BaseJpaProjectContext)this.buildProjectContext();
        context.refreshDefaults((IProgressMonitor)new NullProgressMonitor());
        context.addToMessages(messages);
    }
}

