/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaRelationshipMappingContext;
import org.eclipse.jpt.core.internal.platform.JoinTableContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaMultiRelationshipMappingContext
extends JavaRelationshipMappingContext {
    private JoinTableContext joinTableContext;

    protected JavaMultiRelationshipMappingContext(IContext parentContext, JavaMultiRelationshipMapping mapping) {
        super(parentContext, mapping);
        this.joinTableContext = new JoinTableContext(this, mapping.getJoinTable());
    }

    @Override
    protected void refreshDefaultsInternal(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaultsInternal(defaultsContext, monitor);
        this.joinTableContext.refreshDefaults(defaultsContext, monitor);
    }

    @Override
    protected JavaMultiRelationshipMapping getMapping() {
        return (JavaMultiRelationshipMapping)super.getMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        JavaMultiRelationshipMapping mapping = this.getMapping();
        if (mapping.isJoinTableSpecified()) {
            this.addJoinTableMessages(messages);
        }
        if (mapping.getMappedBy() != null) {
            this.addMappedByMessages(messages);
        }
    }

    protected void addJoinTableMessages(List<IMessage> messages) {
        JavaMultiRelationshipMapping mapping = this.getMapping();
        IJoinTable joinTable = mapping.getJoinTable();
        boolean doContinue = joinTable.isConnected();
        String schema = joinTable.getSchema();
        if (doContinue && !joinTable.hasResolvedSchema()) {
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, joinTable.getName()}, joinTable, joinTable.schemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !joinTable.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{joinTable.getName()}, joinTable, joinTable.nameTextRange()));
            doContinue = false;
        }
        for (IJoinColumn joinColumn : joinTable.getJoinColumns()) {
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
        }
        for (IJoinColumn joinColumn : joinTable.getInverseJoinColumns()) {
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
        }
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        INonOwningMapping mappedByMapping;
        IEntity targetEntity;
        JavaMultiRelationshipMapping mapping = this.getMapping();
        String mappedBy = mapping.getMappedBy();
        if (mapping.isJoinTableSpecified()) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", mapping.getJoinTable(), mapping.getJoinTable().validationTextRange()));
        }
        if ((targetEntity = mapping.getResolvedTargetEntity()) == null) {
            return;
        }
        IPersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        if (!mapping.mappedByIsValid(attribute.getMapping())) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (INonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", mapping, mapping.mappedByTextRange()));
        }
    }
}

