/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.PrimaryKeyJoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryTableContext
extends BaseContext {
    private ISecondaryTable secondaryTable;
    private Collection<PrimaryKeyJoinColumnContext> pkJoinColumnContexts;

    public SecondaryTableContext(IContext parentContext, ISecondaryTable secondaryTable) {
        super(parentContext);
        this.secondaryTable = secondaryTable;
        this.pkJoinColumnContexts = this.buildPkJoinColumnContexts();
    }

    protected Collection<PrimaryKeyJoinColumnContext> buildPkJoinColumnContexts() {
        ArrayList<PrimaryKeyJoinColumnContext> contexts = new ArrayList<PrimaryKeyJoinColumnContext>();
        for (IPrimaryKeyJoinColumn pkJoinColumn : this.getSecondaryTable().getPrimaryKeyJoinColumns()) {
            contexts.add(this.buildPrimaryKeyJoinColumnContext(pkJoinColumn));
        }
        return contexts;
    }

    protected PrimaryKeyJoinColumnContext buildPrimaryKeyJoinColumnContext(IPrimaryKeyJoinColumn pkJoinColumn) {
        return new PrimaryKeyJoinColumnContext((IContext)this, pkJoinColumn);
    }

    @Override
    protected void initialize() {
    }

    public ISecondaryTable getSecondaryTable() {
        return this.secondaryTable;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaults(defaultsContext, monitor);
        this.secondaryTable.refreshDefaults(defaultsContext);
        for (PrimaryKeyJoinColumnContext context : this.pkJoinColumnContexts) {
            context.refreshDefaults(defaultsContext, monitor);
        }
    }

    public DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                return super.getDefault(key);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        for (PrimaryKeyJoinColumnContext context : this.pkJoinColumnContexts) {
            context.addToMessages(messages);
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        boolean doContinue = this.secondaryTable.isConnected();
        String schema = this.secondaryTable.getSchema();
        if (doContinue && !this.secondaryTable.hasResolvedSchema()) {
            messages.add(JpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.secondaryTable.getName()}, this.secondaryTable, this.secondaryTable.schemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !this.secondaryTable.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_NAME", new String[]{this.secondaryTable.getName()}, this.secondaryTable, this.secondaryTable.nameTextRange()));
        }
    }
}

