/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableContext
extends BaseContext {
    private ITable table;

    public TableContext(IContext parentContext, ITable table) {
        super(parentContext);
        this.table = table;
    }

    @Override
    protected void initialize() {
    }

    public ITable getTable() {
        return this.table;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaults(defaultsContext, monitor);
        this.table.refreshDefaults(defaultsContext);
    }

    public DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                if (key.equals("column.table")) {
                    return TableContext.this.getTable().getName();
                }
                return super.getDefault(key);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        boolean doContinue = this.table.isConnected();
        String schema = this.table.getSchema();
        if (doContinue && !this.table.hasResolvedSchema()) {
            messages.add(JpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.table.getName()}, this.table, this.table.schemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !this.table.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_NAME", new String[]{this.table.getName()}, this.table, this.table.nameTextRange()));
        }
    }
}

