/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.persistence;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PersistenceUnitTransactionType implements Enumerator
{
    JTA(0, "JTA", "JTA"),
    RESOURCE_LOCAL(1, "RESOURCE_LOCAL", "RESOURCE_LOCAL");

    public static final int JTA_VALUE = 0;
    public static final int RESOURCE_LOCAL_VALUE = 1;
    private static final PersistenceUnitTransactionType[] VALUES_ARRAY;
    public static final List<PersistenceUnitTransactionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PersistenceUnitTransactionType[]{JTA, RESOURCE_LOCAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PersistenceUnitTransactionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceUnitTransactionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceUnitTransactionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceUnitTransactionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceUnitTransactionType get(int value) {
        switch (value) {
            case 0: {
                return JTA;
            }
            case 1: {
                return RESOURCE_LOCAL;
            }
        }
        return null;
    }

    private PersistenceUnitTransactionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

