/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.modelquery;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.XMLCatalogIdResolver;
import org.eclipse.wst.xml.core.internal.modelquery.XMLModelQueryImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapterImpl;

public class ModelQueryAdapterFactoryForXML
extends AbstractAdapterFactory {
    protected ModelQueryAdapterImpl modelQueryAdapterImpl;
    IStructuredModel stateNotifier;
    private InternalModelStateListener internalModelStateListener;
    static /* synthetic */ Class class$0;

    public ModelQueryAdapterFactoryForXML() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, true);
    }

    protected ModelQueryAdapterFactoryForXML(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
        this.stateNotifier = null;
    }

    protected boolean autoLoadCM() {
        return true;
    }

    protected void configureDocumentManager(CMDocumentManager mgr) {
        mgr.setPropertyEnabled("autoLoad", this.autoLoadCM());
    }

    public INodeAdapterFactory copy() {
        return new ModelQueryAdapterFactoryForXML(this.getAdapterKey(), this.isShouldRegisterAdapter());
    }

    protected INodeAdapter createAdapter(INodeNotifier target) {
        if (this.modelQueryAdapterImpl == null && target instanceof IDOMNode) {
            CMDocumentCache cmDocumentCache;
            XMLModelQueryImpl modelQuery;
            CMDocumentManager documentManager;
            IDOMNode xmlNode = (IDOMNode)target;
            IDOMModel model = xmlNode.getModel();
            this.stateNotifier = xmlNode.getModel();
            this.stateNotifier.addModelStateListener((IModelStateListener)this.getInternalModelStateListener());
            URIResolver resolver = model.getResolver();
            XMLCatalogIdResolver idResolver = null;
            if (resolver != null) {
                idResolver = new XMLCatalogIdResolver(resolver.getFileBaseLocation(), resolver);
            }
            if ((documentManager = (modelQuery = new XMLModelQueryImpl(cmDocumentCache = new CMDocumentCache(), idResolver)).getCMDocumentManager()) != null) {
                this.configureDocumentManager(documentManager);
            }
            this.modelQueryAdapterImpl = new ModelQueryAdapterImpl(cmDocumentCache, modelQuery, idResolver);
        }
        return this.modelQueryAdapterImpl;
    }

    public void release() {
        super.release();
        if (this.stateNotifier != null) {
            this.stateNotifier.removeModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        this.stateNotifier = null;
        if (this.modelQueryAdapterImpl != null) {
            this.modelQueryAdapterImpl.release();
        }
    }

    protected void updateResolver(IStructuredModel model) {
        String baseLocation = model.getBaseLocation();
        IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()));
        if (baseFile != null) {
            if (baseFile.getLocation() != null) {
                baseLocation = baseFile.getLocation().toString();
            }
            if (baseLocation == null && baseFile.getLocationURI() != null) {
                baseLocation = baseFile.getLocationURI().toString();
            }
            if (baseLocation == null) {
                baseLocation = baseFile.getFullPath().toString();
            }
        } else {
            baseLocation = model.getBaseLocation();
        }
        this.modelQueryAdapterImpl.setIdResolver(new XMLCatalogIdResolver(baseLocation, model.getResolver()));
    }

    private final InternalModelStateListener getInternalModelStateListener() {
        if (this.internalModelStateListener == null) {
            this.internalModelStateListener = new InternalModelStateListener();
        }
        return this.internalModelStateListener;
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelChanged(IStructuredModel model) {
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            ModelQueryAdapterFactoryForXML.this.stateNotifier.removeModelStateListener((IModelStateListener)this);
            ModelQueryAdapterFactoryForXML.this.stateNotifier = newModel;
            ModelQueryAdapterFactoryForXML.this.updateResolver(ModelQueryAdapterFactoryForXML.this.stateNotifier);
            ModelQueryAdapterFactoryForXML.this.stateNotifier.addModelStateListener((IModelStateListener)this);
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
            ModelQueryAdapterFactoryForXML.this.updateResolver(structuredModel);
        }
    }
}

