/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.transport.TransportException;

public class RegPublishServiceInterfaceSimpleAction
extends PublishAction {
    public RegPublishServiceInterfaceSimpleAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(2));
        this.propertyTable_.put("queryStyleServiceInterfaces", String.valueOf(0));
    }

    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String wsdlURL = parser.getParameter("wsdlURL");
        String name = parser.getParameter("simpleServiceInterfaceName");
        String description = parser.getParameter("simpleServiceInterfaceDescription");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (wsdlURL != null) {
            this.propertyTable_.put("simpleServiceInterfaceWSDLURL", wsdlURL);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(wsdlURL)) {
            inputsValid = false;
            formToolPI.flagError("simpleServiceInterfaceWSDLURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
        }
        if (name != null) {
            this.propertyTable_.put("simpleServiceInterfaceName", name);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(name)) {
            inputsValid = false;
            formToolPI.flagError("simpleServiceInterfaceName");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
        }
        if (description != null) {
            this.propertyTable_.put("simpleServiceInterfaceDescription", description);
        }
        return inputsValid;
    }

    public final boolean populatePropertyTable(String wsdlURL, TModel tModel) {
        boolean inputsValid = true;
        String name = tModel.getNameString();
        String description = tModel.getDefaultDescriptionString();
        if (wsdlURL != null) {
            this.propertyTable_.put("simpleServiceInterfaceWSDLURL", wsdlURL);
        } else {
            inputsValid = false;
        }
        if (name != null) {
            this.propertyTable_.put("simpleServiceInterfaceName", name);
        } else {
            inputsValid = false;
        }
        if (description != null) {
            this.propertyTable_.put("simpleServiceInterfaceDescription", description);
        } else {
            this.propertyTable_.put("simpleServiceInterfaceDescription", "");
        }
        return inputsValid;
    }

    public final boolean run() {
        String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
        String userId = (String)this.propertyTable_.get("advancedUserId");
        String password = (String)this.propertyTable_.get("advancedPassword");
        String wsdlURL = (String)this.propertyTable_.get("simpleServiceInterfaceWSDLURL");
        String name = (String)this.propertyTable_.get("simpleServiceInterfaceName");
        String description = (String)this.propertyTable_.get("simpleServiceInterfaceDescription");
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        try {
            UDDIProxy proxy = regElement.getProxy();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            TModel tModel = new Uddi4jHelper().newTModel(wsdlURL);
            tModel.setName(name);
            tModel.setDefaultDescriptionString(description);
            Vector<TModel> tModelVector = new Vector<TModel>();
            tModelVector.add(tModel);
            tModel = (TModel)proxy.save_tModel(regElement.getAuthInfoString(), tModelVector).getTModelVector().get(0);
            this.propertyTable_.put("savedTModel", tModel);
            this.addPublishedItemNode(tModel, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_INTERFACE_PUBLISHED", tModel.getNameString()));
            return true;
        }
        catch (WSDLException e) {
            e.printStackTrace();
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("WSDLException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (TransportException e) {
            e.printStackTrace();
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                regElement.setDefaults();
            }
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

