/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.Iterator;
import javax.wsdl.Part;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.HTTPUtil;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;

public abstract class InvokeWSDLHttpOperationFormAction
extends WSDLPropertiesFormAction {
    private static final String CONTENT_TYPE_CHARSETEQ = "charset=";

    public InvokeWSDLHttpOperationFormAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        String endPoint = parser.getParameter("::endPoint");
        Node selectedNode = this.getSelectedNavigatorNode();
        InvokeWSDLOperationTool invokeWSDLOperationTool = (InvokeWSDLOperationTool)selectedNode.getCurrentToolManager().getSelectedTool();
        invokeWSDLOperationTool.setEndPoint(endPoint);
        WSDLOperationElement operElement = (WSDLOperationElement)selectedNode.getTreeElement();
        this.propertyTable_.put("operationElement", operElement);
        Iterator it = operElement.getOrderedBodyParts().iterator();
        boolean resultsValid = true;
        while (it.hasNext()) {
            Part part = (Part)it.next();
            IXSDFragment frag = operElement.getFragment(part);
            if (frag.processParameterValues(parser)) continue;
            resultsValid = false;
        }
        return resultsValid;
    }

    protected String getEndPoint() {
        StringBuffer endPoint = new StringBuffer((String)this.propertyTable_.get("::endPoint"));
        WSDLOperationElement operElement = (WSDLOperationElement)((Object)this.propertyTable_.get("operationElement"));
        if (endPoint.charAt(endPoint.length() - 1) != '/') {
            endPoint.append('/');
        }
        endPoint.append(operElement.getName());
        return endPoint.toString();
    }

    protected void addParameters(StringBuffer buffer) {
        WSDLOperationElement operElement = (WSDLOperationElement)((Object)this.propertyTable_.get("operationElement"));
        Iterator it = operElement.getOrderedBodyParts().iterator();
        while (it.hasNext()) {
            Part part = (Part)it.next();
            IXSDFragment frag = operElement.getFragment(part);
            buffer.append(HTTPUtil.genURLEncodedParameters(frag));
            if (!it.hasNext()) continue;
            buffer.append('&');
        }
    }

    protected void recordHttpResponse(URLConnection conn, MessageQueue messageQueue) throws IOException {
        BufferedReader br = null;
        try {
            String s;
            int charsetEqPos;
            InputStreamReader in = null;
            String contentType = conn.getContentType();
            if (contentType != null && (charsetEqPos = contentType.indexOf(CONTENT_TYPE_CHARSETEQ)) != -1) {
                in = new InputStreamReader(conn.getInputStream(), contentType.substring(charsetEqPos + CONTENT_TYPE_CHARSETEQ.length()));
            }
            if (in == null) {
                in = new InputStreamReader(conn.getInputStream());
            }
            br = new BufferedReader(in);
            while ((s = br.readLine()) != null) {
                messageQueue.addMessage(s);
            }
            br.close();
            br = null;
        }
        catch (IOException e) {
            if (br != null) {
                br.close();
            }
            throw e;
        }
    }
}

