/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMSubProperty;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundPositionXSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundPositionYSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderBottomShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderColorShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderLeftShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderRightShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderStyleShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderTopShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderWidthShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipBottomSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipLeftSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipRightSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipTopSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.FontShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ICSS2Properties;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ISubPropertyAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ListStyleShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.MarginShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.PaddingShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ValueData;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyContext
implements ICSS2Properties {
    protected Hashtable fProperties = new Hashtable();
    HashSet fModified = null;
    private static Hashtable subPropertyAdapters;
    private static Hashtable shorthandAdapters;

    public CSSPropertyContext() {
        CSSPropertyContext.initShorthandAdapters();
        CSSPropertyContext.initSubPropertyAdapters();
    }

    public CSSPropertyContext(ICSSStyleDeclaration decl) {
        CSSPropertyContext.initShorthandAdapters();
        CSSPropertyContext.initSubPropertyAdapters();
        this.initialize(decl);
    }

    public void applyFull(ICSSStyleDeclaration decl) {
        if (decl == null) {
            return;
        }
        Enumeration keys = this.fProperties.keys();
        while (keys.hasMoreElements()) {
            String value;
            Object key = keys.nextElement();
            Object val = this.fProperties.get(key);
            String string = value = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : val.toString();
            if (value == null || value.length() <= 0) {
                decl.removeProperty(key.toString());
                continue;
            }
            decl.setProperty(key.toString(), value.trim(), val instanceof ValueData && ((ValueData)val).important ? "!important" : "");
        }
    }

    public void applyModified(ICSSStyleDeclaration decl) {
        if (decl == null || this.fModified == null) {
            return;
        }
        Iterator it = this.fModified.iterator();
        while (it.hasNext()) {
            String value;
            Object key = it.next();
            Object val = this.fProperties.get(key);
            String string = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : (value = val != null ? val.toString() : null);
            if (value == null || value.length() <= 0) {
                decl.removeProperty(key.toString());
                continue;
            }
            decl.setProperty(key.toString(), value.trim(), val instanceof ValueData && ((ValueData)val).important ? "!important" : "");
        }
    }

    public Object clone() {
        CSSPropertyContext clone = new CSSPropertyContext();
        clone.fModified = this.fModified != null ? (HashSet)this.fModified.clone() : null;
        clone.fProperties = (Hashtable)this.fProperties.clone();
        return clone;
    }

    protected static void expandToLeaf(PropCMProperty prop, String value, CSSPropertyContext foreign) {
        if (value != null && value.trim().length() > 0) {
            IShorthandAdapter adapter = (IShorthandAdapter)shorthandAdapters.get(prop);
            if (adapter != null) {
                adapter.expand(value, foreign);
                foreign.set(prop.getName(), "");
                int i = 0;
                while (i < prop.getNumChild()) {
                    Object obj = prop.getChildAt(i);
                    if (obj instanceof PropCMProperty && !(obj instanceof PropCMSubProperty)) {
                        PropCMProperty expandedProp = (PropCMProperty)obj;
                        value = foreign.get(expandedProp.getName());
                        CSSPropertyContext.expandToLeaf(expandedProp, value, foreign);
                    }
                    ++i;
                }
            } else if (!value.equals(foreign.get(prop.getName()))) {
                foreign.set(prop.getName(), value);
            }
        }
    }

    public String get(PropCMProperty prop) {
        ISubPropertyAdapter adapter;
        if (prop instanceof PropCMSubProperty && (adapter = (ISubPropertyAdapter)subPropertyAdapters.get(prop.getName())) != null) {
            return adapter.get(this);
        }
        String str = this.get(prop.getName());
        if ((str == null || str.length() == 0) && prop.getShorthandContainerCount() > 0) {
            int i = 0;
            while (i < prop.getShorthandContainerCount()) {
                IShorthandAdapter adapter2;
                PropCMProperty propParent = prop.shorthandContainerAt(i);
                String strParent = this.get(propParent);
                if (strParent != null && strParent.trim().length() > 0 && (adapter2 = (IShorthandAdapter)shorthandAdapters.get(propParent)) != null) {
                    String extractedValue = adapter2.extract(strParent, prop);
                    return extractedValue != null ? extractedValue : "";
                }
                ++i;
            }
        }
        return str;
    }

    protected String get(String propName) {
        String str = null;
        Object obj = this.fProperties.get(propName);
        if (obj != null) {
            str = obj instanceof ICSSValue ? ((ICSSValue)obj).getCSSValueText() : obj.toString();
        }
        return str != null ? str : "";
    }

    public String getAzimuth() {
        return this.get(PropCMProperty.getInstanceOf("azimuth"));
    }

    public String getBackground() {
        return this.get(PropCMProperty.getInstanceOf("background"));
    }

    public String getBackgroundAttachment() {
        return this.get(PropCMProperty.getInstanceOf("background-attachment"));
    }

    public String getBackgroundColor() {
        return this.get(PropCMProperty.getInstanceOf("background-color"));
    }

    public String getBackgroundImage() {
        return this.get(PropCMProperty.getInstanceOf("background-image"));
    }

    public String getBackgroundPosition() {
        return this.get(PropCMProperty.getInstanceOf("background-position"));
    }

    public String getBackgroundPositionX() {
        return this.get(PropCMSubProperty.getInstanceOf("background-positionH"));
    }

    public String getBackgroundPositionY() {
        return this.get(PropCMSubProperty.getInstanceOf("background-positionV"));
    }

    public String getBackgroundRepeat() {
        return this.get(PropCMProperty.getInstanceOf("background-repeat"));
    }

    public String getBorder() {
        return this.get(PropCMProperty.getInstanceOf("border"));
    }

    public String getBorderBottom() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom"));
    }

    public String getBorderBottomColor() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-color"));
    }

    public String getBorderBottomStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-style"));
    }

    public String getBorderBottomWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-width"));
    }

    public String getBorderCollapse() {
        return this.get(PropCMProperty.getInstanceOf("border-collapse"));
    }

    public String getBorderColor() {
        return this.get(PropCMProperty.getInstanceOf("border-color"));
    }

    public String getBorderLeft() {
        return this.get(PropCMProperty.getInstanceOf("border-left"));
    }

    public String getBorderLeftColor() {
        return this.get(PropCMProperty.getInstanceOf("border-left-color"));
    }

    public String getBorderLeftStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-left-style"));
    }

    public String getBorderLeftWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-left-width"));
    }

    public String getBorderRight() {
        return this.get(PropCMProperty.getInstanceOf("border-right"));
    }

    public String getBorderRightColor() {
        return this.get(PropCMProperty.getInstanceOf("border-right-color"));
    }

    public String getBorderRightStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-right-style"));
    }

    public String getBorderRightWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-right-width"));
    }

    public String getBorderSpacing() {
        return this.get(PropCMProperty.getInstanceOf("border-spacing"));
    }

    public String getBorderStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-style"));
    }

    public String getBorderTop() {
        return this.get(PropCMProperty.getInstanceOf("border-top"));
    }

    public String getBorderTopColor() {
        return this.get(PropCMProperty.getInstanceOf("border-top-color"));
    }

    public String getBorderTopStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-top-style"));
    }

    public String getBorderTopWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-top-width"));
    }

    public String getBorderWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-width"));
    }

    public String getBottom() {
        return this.get(PropCMProperty.getInstanceOf("bottom"));
    }

    public String getCaptionSide() {
        return this.get(PropCMProperty.getInstanceOf("caption-side"));
    }

    public String getClear() {
        return this.get(PropCMProperty.getInstanceOf("clear"));
    }

    public String getClip() {
        return this.get(PropCMProperty.getInstanceOf("clip"));
    }

    public String getClipBottom() {
        return this.get(PropCMSubProperty.getInstanceOf("clipBottom"));
    }

    public String getClipLeft() {
        return this.get(PropCMSubProperty.getInstanceOf("clipLeft"));
    }

    public String getClipRight() {
        return this.get(PropCMSubProperty.getInstanceOf("clipRight"));
    }

    public String getClipTop() {
        return this.get(PropCMSubProperty.getInstanceOf("clipTop"));
    }

    public String getColor() {
        return this.get(PropCMProperty.getInstanceOf("color"));
    }

    public String getContent() {
        return this.get(PropCMProperty.getInstanceOf("content"));
    }

    public String getCounterIncrement() {
        return this.get(PropCMProperty.getInstanceOf("counter-increment"));
    }

    public String getCounterReset() {
        return this.get(PropCMProperty.getInstanceOf("counter-reset"));
    }

    public String getCssFloat() {
        return this.get(PropCMProperty.getInstanceOf("float"));
    }

    public String getCue() {
        return this.get(PropCMProperty.getInstanceOf("cue"));
    }

    public String getCueAfter() {
        return this.get(PropCMProperty.getInstanceOf("cue-after"));
    }

    public String getCueBefore() {
        return this.get(PropCMProperty.getInstanceOf("cue-before"));
    }

    public String getCursor() {
        return this.get(PropCMProperty.getInstanceOf("cursor"));
    }

    public String getDirection() {
        return this.get(PropCMProperty.getInstanceOf("direction"));
    }

    public String getDisplay() {
        return this.get(PropCMProperty.getInstanceOf("display"));
    }

    public String getElevation() {
        return this.get(PropCMProperty.getInstanceOf("elevation"));
    }

    public String getEmptyCells() {
        return this.get(PropCMProperty.getInstanceOf("empty-cells"));
    }

    public String getFont() {
        return this.get(PropCMProperty.getInstanceOf("font"));
    }

    public String getFontFamily() {
        return this.get(PropCMProperty.getInstanceOf("font-family"));
    }

    public String getFontSize() {
        return this.get(PropCMProperty.getInstanceOf("font-size"));
    }

    public String getFontSizeAdjust() {
        return this.get(PropCMProperty.getInstanceOf("font-size-adjust"));
    }

    public String getFontStretch() {
        return this.get(PropCMProperty.getInstanceOf("font-stretch"));
    }

    public String getFontStyle() {
        return this.get(PropCMProperty.getInstanceOf("font-style"));
    }

    public String getFontVariant() {
        return this.get(PropCMProperty.getInstanceOf("font-variant"));
    }

    public String getFontWeight() {
        return this.get(PropCMProperty.getInstanceOf("font-weight"));
    }

    public String getHeight() {
        return this.get(PropCMProperty.getInstanceOf("height"));
    }

    public String getLeft() {
        return this.get(PropCMProperty.getInstanceOf("left"));
    }

    public String getLetterSpacing() {
        return this.get(PropCMProperty.getInstanceOf("letter-spacing"));
    }

    public String getLineHeight() {
        return this.get(PropCMProperty.getInstanceOf("line-height"));
    }

    public String getListStyle() {
        return this.get(PropCMProperty.getInstanceOf("list-style"));
    }

    public String getListStyleImage() {
        return this.get(PropCMProperty.getInstanceOf("list-style-image"));
    }

    public String getListStylePosition() {
        return this.get(PropCMProperty.getInstanceOf("list-style-position"));
    }

    public String getListStyleType() {
        return this.get(PropCMProperty.getInstanceOf("list-style-type"));
    }

    public String getMargin() {
        return this.get(PropCMProperty.getInstanceOf("margin"));
    }

    public String getMarginBottom() {
        return this.get(PropCMProperty.getInstanceOf("margin-bottom"));
    }

    public String getMarginLeft() {
        return this.get(PropCMProperty.getInstanceOf("margin-left"));
    }

    public String getMarginRight() {
        return this.get(PropCMProperty.getInstanceOf("margin-right"));
    }

    public String getMarginTop() {
        return this.get(PropCMProperty.getInstanceOf("margin-top"));
    }

    public String getMarkerOffset() {
        return this.get(PropCMProperty.getInstanceOf("marker-offset"));
    }

    public String getMarks() {
        return this.get(PropCMProperty.getInstanceOf("marks"));
    }

    public String getMaxHeight() {
        return this.get(PropCMProperty.getInstanceOf("max-height"));
    }

    public String getMaxWidth() {
        return this.get(PropCMProperty.getInstanceOf("max-width"));
    }

    public String getMinHeight() {
        return this.get(PropCMProperty.getInstanceOf("min-height"));
    }

    public String getMinWidth() {
        return this.get(PropCMProperty.getInstanceOf("min-width"));
    }

    public String getOrphans() {
        return this.get(PropCMProperty.getInstanceOf("orphans"));
    }

    public String getOutline() {
        return this.get(PropCMProperty.getInstanceOf("outline"));
    }

    public String getOutlineColor() {
        return this.get(PropCMProperty.getInstanceOf("outline-color"));
    }

    public String getOutlineStyle() {
        return this.get(PropCMProperty.getInstanceOf("outline-style"));
    }

    public String getOutlineWidth() {
        return this.get(PropCMProperty.getInstanceOf("outline-width"));
    }

    public String getOverflow() {
        return this.get(PropCMProperty.getInstanceOf("overflow"));
    }

    public String getPadding() {
        return this.get(PropCMProperty.getInstanceOf("padding"));
    }

    public String getPaddingBottom() {
        return this.get(PropCMProperty.getInstanceOf("padding-bottom"));
    }

    public String getPaddingLeft() {
        return this.get(PropCMProperty.getInstanceOf("padding-left"));
    }

    public String getPaddingRight() {
        return this.get(PropCMProperty.getInstanceOf("padding-right"));
    }

    public String getPaddingTop() {
        return this.get(PropCMProperty.getInstanceOf("padding-top"));
    }

    public String getPage() {
        return this.get(PropCMProperty.getInstanceOf("page"));
    }

    public String getPageBreakAfter() {
        return this.get(PropCMProperty.getInstanceOf("page-break-after"));
    }

    public String getPageBreakBefore() {
        return this.get(PropCMProperty.getInstanceOf("page-break-before"));
    }

    public String getPageBreakInside() {
        return this.get(PropCMProperty.getInstanceOf("page-break-inside"));
    }

    public String getPause() {
        return this.get(PropCMProperty.getInstanceOf("pause"));
    }

    public String getPauseAfter() {
        return this.get(PropCMProperty.getInstanceOf("pause-after"));
    }

    public String getPauseBefore() {
        return this.get(PropCMProperty.getInstanceOf("pause-before"));
    }

    public String getPitch() {
        return this.get(PropCMProperty.getInstanceOf("pitch"));
    }

    public String getPitchRange() {
        return this.get(PropCMProperty.getInstanceOf("pitch-range"));
    }

    public String getPlayDuring() {
        return this.get(PropCMProperty.getInstanceOf("play-during"));
    }

    public String getPosition() {
        return this.get(PropCMProperty.getInstanceOf("position"));
    }

    public String getQuotes() {
        return this.get(PropCMProperty.getInstanceOf("quotes"));
    }

    public String getRichness() {
        return this.get(PropCMProperty.getInstanceOf("richness"));
    }

    public String getRight() {
        return this.get(PropCMProperty.getInstanceOf("right"));
    }

    public static IShorthandAdapter getShorthandAdapter(PropCMProperty prop) {
        return (IShorthandAdapter)shorthandAdapters.get(prop);
    }

    public String getSize() {
        return this.get(PropCMProperty.getInstanceOf("size"));
    }

    public String getSpeak() {
        return this.get(PropCMProperty.getInstanceOf("speak"));
    }

    public String getSpeakHeader() {
        return this.get(PropCMProperty.getInstanceOf("speak-header"));
    }

    public String getSpeakNumeral() {
        return this.get(PropCMProperty.getInstanceOf("speak-numeral"));
    }

    public String getSpeakPunctuation() {
        return this.get(PropCMProperty.getInstanceOf("speak-punctuation"));
    }

    public String getSpeechRate() {
        return this.get(PropCMProperty.getInstanceOf("speech-rate"));
    }

    public String getStress() {
        return this.get(PropCMProperty.getInstanceOf("stress"));
    }

    public String getTableLayout() {
        return this.get(PropCMProperty.getInstanceOf("table-layout"));
    }

    public String getTextAlign() {
        return this.get(PropCMProperty.getInstanceOf("text-align"));
    }

    public String getTextDecoration() {
        return this.get(PropCMProperty.getInstanceOf("text-decoration"));
    }

    public String getTextIndent() {
        return this.get(PropCMProperty.getInstanceOf("text-indent"));
    }

    public String getTextShadow() {
        return this.get(PropCMProperty.getInstanceOf("text-shadow"));
    }

    public String getTextTransform() {
        return this.get(PropCMProperty.getInstanceOf("text-transform"));
    }

    public String getTop() {
        return this.get(PropCMProperty.getInstanceOf("top"));
    }

    public String getUnicodeBidi() {
        return this.get(PropCMProperty.getInstanceOf("unicode-bidi"));
    }

    public String getVerticalAlign() {
        return this.get(PropCMProperty.getInstanceOf("vertical-align"));
    }

    public String getVisibility() {
        return this.get(PropCMProperty.getInstanceOf("visibility"));
    }

    public String getVoiceFamily() {
        return this.get(PropCMProperty.getInstanceOf("voice-family"));
    }

    public String getVolume() {
        return this.get(PropCMProperty.getInstanceOf("volume"));
    }

    public String getWhiteSpace() {
        return this.get(PropCMProperty.getInstanceOf("white-space"));
    }

    public String getWidows() {
        return this.get(PropCMProperty.getInstanceOf("widows"));
    }

    public String getWidth() {
        return this.get(PropCMProperty.getInstanceOf("width"));
    }

    public String getWordSpacing() {
        return this.get(PropCMProperty.getInstanceOf("word-spacing"));
    }

    public String getZIndex() {
        return this.get(PropCMProperty.getInstanceOf("z-index"));
    }

    public void initialize(ICSSStyleDeclaration decl) {
        this.fProperties.clear();
        if (this.fModified != null) {
            this.fModified.clear();
        }
        if (decl == null) {
            return;
        }
        int nProperties = decl.getLength();
        int i = 0;
        while (i < nProperties) {
            CSSValue val;
            String propN;
            String propName = decl.item(i);
            if (propName != null && (propN = propName.trim().toLowerCase()).length() != 0 && (val = decl.getPropertyCSSValue(propName)) != null) {
                this.fProperties.put(propN, val);
            }
            ++i;
        }
    }

    static void initShorthandAdapters() {
        if (shorthandAdapters == null) {
            shorthandAdapters = new Hashtable();
            shorthandAdapters.put(PropCMProperty.getInstanceOf("background"), new BackgroundShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border"), new BorderShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-color"), new BorderColorShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-style"), new BorderStyleShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-width"), new BorderWidthShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-top"), new BorderTopShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-right"), new BorderRightShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-bottom"), new BorderBottomShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-left"), new BorderLeftShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("font"), new FontShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("list-style"), new ListStyleShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("margin"), new MarginShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("padding"), new PaddingShorthandAdapter());
        }
    }

    static void initSubPropertyAdapters() {
        if (subPropertyAdapters == null) {
            subPropertyAdapters = new Hashtable();
            subPropertyAdapters.put("background-positionH", new BackgroundPositionXSubStyleAdapter());
            subPropertyAdapters.put("background-positionV", new BackgroundPositionYSubStyleAdapter());
            subPropertyAdapters.put("clipTop", new ClipTopSubStyleAdapter());
            subPropertyAdapters.put("clipRight", new ClipRightSubStyleAdapter());
            subPropertyAdapters.put("clipBottom", new ClipBottomSubStyleAdapter());
            subPropertyAdapters.put("clipLeft", new ClipLeftSubStyleAdapter());
        }
    }

    public boolean isModified() {
        return this.fModified != null && this.fModified.size() != 0;
    }

    public Enumeration properties() {
        return this.fProperties.keys();
    }

    public Iterator propertiesModified() {
        if (this.fModified != null) {
            return ((Collection)this.fModified.clone()).iterator();
        }
        return new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            public void remove() {
            }
        };
    }

    protected void recursiveExtract(PropCMProperty prop, CSSPropertyContext foreign) {
        IShorthandAdapter adapter;
        int i = 0;
        while (i < prop.getShorthandContainerCount()) {
            this.recursiveExtract(prop.shorthandContainerAt(i), foreign);
            ++i;
        }
        String str = this.get(prop.getName());
        if (str == null || str.trim().length() == 0) {
            str = foreign.get(prop.getName());
        }
        if (str != null && str.trim().length() > 0 && (adapter = (IShorthandAdapter)shorthandAdapters.get(prop)) != null) {
            adapter.expand(str, foreign);
            foreign.set(prop.getName(), "");
        }
    }

    protected void removeDescendants(PropCMProperty prop) {
        if (prop.isShorthand()) {
            int n = prop.getNumChild();
            int i = 0;
            while (i < n) {
                Object obj = prop.getChildAt(i);
                if (obj instanceof PropCMProperty) {
                    this.removeDescendants((PropCMProperty)obj);
                    String str = this.get(obj.toString());
                    if (str != null && str.length() > 0) {
                        this.set(obj.toString(), "");
                    }
                }
                ++i;
            }
        }
    }

    public void resetModified() {
        if (this.fModified != null) {
            this.fModified.clear();
        }
    }

    public void set(PropCMProperty prop, String value) throws DOMException {
        ISubPropertyAdapter adapter;
        if (prop instanceof PropCMSubProperty && (adapter = (ISubPropertyAdapter)subPropertyAdapters.get(prop.getName())) != null) {
            adapter.set(this, value);
            return;
        }
        if (prop.getShorthandContainerCount() > 0) {
            CSSPropertyContext context = new CSSPropertyContext();
            int i = 0;
            while (i < prop.getShorthandContainerCount()) {
                this.recursiveExtract(prop.shorthandContainerAt(i), context);
                ++i;
            }
            Enumeration properties = context.properties();
            while (properties.hasMoreElements()) {
                String propForeign = properties.nextElement().toString();
                this.set(propForeign, context.get(propForeign));
            }
        }
        this.removeDescendants(prop);
        this.set(prop.getName(), value);
    }

    protected void set(String propName, String value) throws DOMException {
        String key = propName;
        if (value == null) {
            this.fProperties.remove(key);
        } else {
            this.fProperties.put(key, value);
        }
        if (this.fModified == null) {
            this.fModified = new HashSet();
        }
        this.fModified.add(key);
    }

    public void setAzimuth(String azimuth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("azimuth"), azimuth);
    }

    public void setBackground(String background) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background"), background);
    }

    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-attachment"), backgroundAttachment);
    }

    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-color"), backgroundColor);
    }

    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-image"), backgroundImage);
    }

    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-position"), backgroundPosition);
    }

    public void setBackgroundPositionX(String backgroundPositionX) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("background-positionH"), backgroundPositionX);
    }

    public void setBackgroundPositionY(String backgroundPositionY) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("background-positionV"), backgroundPositionY);
    }

    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-repeat"), backgroundRepeat);
    }

    public void setBorder(String border) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border"), border);
    }

    public void setBorderBottom(String borderBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom"), borderBottom);
    }

    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-color"), borderBottomColor);
    }

    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-style"), borderBottomStyle);
    }

    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-width"), borderBottomWidth);
    }

    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-collapse"), borderCollapse);
    }

    public void setBorderColor(String borderColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-color"), borderColor);
    }

    public void setBorderLeft(String borderLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left"), borderLeft);
    }

    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-color"), borderLeftColor);
    }

    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-style"), borderLeftStyle);
    }

    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-width"), borderLeftWidth);
    }

    public void setBorderRight(String borderRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right"), borderRight);
    }

    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-color"), borderRightColor);
    }

    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-style"), borderRightStyle);
    }

    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-width"), borderRightWidth);
    }

    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-spacing"), borderSpacing);
    }

    public void setBorderStyle(String borderStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-style"), borderStyle);
    }

    public void setBorderTop(String borderTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top"), borderTop);
    }

    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-color"), borderTopColor);
    }

    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-style"), borderTopStyle);
    }

    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-width"), borderTopWidth);
    }

    public void setBorderWidth(String borderWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-width"), borderWidth);
    }

    public void setBottom(String bottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("bottom"), bottom);
    }

    public void setCaptionSide(String captionSide) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("caption-side"), captionSide);
    }

    public void setClear(String clear) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("clear"), clear);
    }

    public void setClip(String clip) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("clip"), clip);
    }

    public void setClipBottom(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipBottom"), clip);
    }

    public void setClipLeft(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipLeft"), clip);
    }

    public void setClipRight(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipRight"), clip);
    }

    public void setClipTop(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipTop"), clip);
    }

    public void setColor(String color) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("color"), color);
    }

    public void setContent(String content) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("content"), content);
    }

    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("counter-increment"), counterIncrement);
    }

    public void setCounterReset(String counterReset) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("counter-reset"), counterReset);
    }

    public void setCssFloat(String cssFloat) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("float"), cssFloat);
    }

    public void setCue(String cue) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue"), cue);
    }

    public void setCueAfter(String cueAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue-after"), cueAfter);
    }

    public void setCueBefore(String cueBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue-before"), cueBefore);
    }

    public void setCursor(String cursor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cursor"), cursor);
    }

    public void setDirection(String direction) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("direction"), direction);
    }

    public void setDisplay(String display) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("display"), display);
    }

    public void setElevation(String elevation) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("elevation"), elevation);
    }

    public void setEmptyCells(String emptyCells) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("empty-cells"), emptyCells);
    }

    public void setFont(String font) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font"), font);
    }

    public void setFontFamily(String fontFamily) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-family"), fontFamily);
    }

    public void setFontSize(String fontSize) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-size"), fontSize);
    }

    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-size-adjust"), fontSizeAdjust);
    }

    public void setFontStretch(String fontStretch) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-stretch"), fontStretch);
    }

    public void setFontStyle(String fontStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-style"), fontStyle);
    }

    public void setFontVariant(String fontVariant) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-variant"), fontVariant);
    }

    public void setFontWeight(String fontWeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-weight"), fontWeight);
    }

    public void setHeight(String height) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("height"), height);
    }

    public void setLeft(String left) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("left"), left);
    }

    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("letter-spacing"), letterSpacing);
    }

    public void setLineHeight(String lineHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("line-height"), lineHeight);
    }

    public void setListStyle(String listStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style"), listStyle);
    }

    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-image"), listStyleImage);
    }

    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-position"), listStylePosition);
    }

    public void setListStyleType(String listStyleType) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-type"), listStyleType);
    }

    public void setMargin(String margin) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin"), margin);
    }

    public void setMarginBottom(String marginBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-bottom"), marginBottom);
    }

    public void setMarginLeft(String marginLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-left"), marginLeft);
    }

    public void setMarginRight(String marginRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-right"), marginRight);
    }

    public void setMarginTop(String marginTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-top"), marginTop);
    }

    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("marker-offset"), markerOffset);
    }

    public void setMarks(String marks) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("marks"), marks);
    }

    public void setMaxHeight(String maxHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("max-height"), maxHeight);
    }

    public void setMaxWidth(String maxWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("max-width"), maxWidth);
    }

    public void setMinHeight(String minHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("min-height"), minHeight);
    }

    public void setMinWidth(String minWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("min-width"), minWidth);
    }

    public void setOrphans(String orphans) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("orphans"), orphans);
    }

    public void setOutline(String outline) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline"), outline);
    }

    public void setOutlineColor(String outlineColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-color"), outlineColor);
    }

    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-style"), outlineStyle);
    }

    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-width"), outlineWidth);
    }

    public void setOverflow(String overflow) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("overflow"), overflow);
    }

    public void setPadding(String padding) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding"), padding);
    }

    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-bottom"), paddingBottom);
    }

    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-left"), paddingLeft);
    }

    public void setPaddingRight(String paddingRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-right"), paddingRight);
    }

    public void setPaddingTop(String paddingTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-top"), paddingTop);
    }

    public void setPage(String page) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page"), page);
    }

    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-after"), pageBreakAfter);
    }

    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-before"), pageBreakBefore);
    }

    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-inside"), pageBreakInside);
    }

    public void setPause(String pause) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause"), pause);
    }

    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause-after"), pauseAfter);
    }

    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause-before"), pauseBefore);
    }

    public void setPitch(String pitch) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pitch"), pitch);
    }

    public void setPitchRange(String pitchRange) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pitch-range"), pitchRange);
    }

    public void setPlayDuring(String playDuring) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("play-during"), playDuring);
    }

    public void setPosition(String position) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("position"), position);
    }

    public void setQuotes(String quotes) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("quotes"), quotes);
    }

    public void setRichness(String richness) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("richness"), richness);
    }

    public void setRight(String right) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("right"), right);
    }

    public void setSize(String size) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("size"), size);
    }

    public void setSpeak(String speak) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak"), speak);
    }

    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-header"), speakHeader);
    }

    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-numeral"), speakNumeral);
    }

    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-punctuation"), speakPunctuation);
    }

    public void setSpeechRate(String speechRate) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speech-rate"), speechRate);
    }

    public void setStress(String stress) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("stress"), stress);
    }

    public void setTableLayout(String tableLayout) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("table-layout"), tableLayout);
    }

    public void setTextAlign(String textAlign) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-align"), textAlign);
    }

    public void setTextDecoration(String textDecoration) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-decoration"), textDecoration);
    }

    public void setTextIndent(String textIndent) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-indent"), textIndent);
    }

    public void setTextShadow(String textShadow) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-shadow"), textShadow);
    }

    public void setTextTransform(String textTransform) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-transform"), textTransform);
    }

    public void setTop(String top) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("top"), top);
    }

    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("unicode-bidi"), unicodeBidi);
    }

    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("vertical-align"), verticalAlign);
    }

    public void setVisibility(String visibility) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("visibility"), visibility);
    }

    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("voice-family"), voiceFamily);
    }

    public void setVolume(String volume) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("volume"), volume);
    }

    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("white-space"), whiteSpace);
    }

    public void setWidows(String widows) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("widows"), widows);
    }

    public void setWidth(String width) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("width"), width);
    }

    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("word-spacing"), wordSpacing);
    }

    public void setZIndex(String zIndex) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("z-index"), zIndex);
    }
}

