/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.preview.adapter.internal.Messages;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;

public class PreviewServer
extends ServerDelegate
implements IURLProvider {
    public static final String ID = "org.eclipse.jst.server.preview.server";
    public static final String PROPERTY_PORT = "port";

    protected void initialize() {
    }

    public PreviewRuntime getPreviewRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (PreviewRuntime)((Object)this.getServer().getRuntime().loadAdapter(PreviewRuntime.class, null));
    }

    public URL getModuleRootURL(IModule module) {
        try {
            String base = "http://localhost";
            int port = this.getPort();
            URL url = null;
            url = port == 80 ? new URL(String.valueOf(base) + "/") : new URL(String.valueOf(base) + ":" + port + "/");
            String type = module.getModuleType().getId();
            if ("wst.web".equals(type)) {
                IStaticWeb staticWeb = (IStaticWeb)module.loadAdapter(IStaticWeb.class, null);
                return new URL(url, staticWeb.getContextRoot());
            }
            if ("jst.web".equals(type)) {
                IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
                return new URL(url, webModule.getContextRoot());
            }
            return url;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not get root URL", e);
            return null;
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        return new IModule[]{module};
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return new Status(0, "org.eclipse.jst.server.preview.adapter", 0, Messages.canModifyModules, null);
    }

    public ServerPort[] getServerPorts() {
        int port = this.getPort();
        ServerPort[] ports = new ServerPort[]{new ServerPort("http", Messages.httpPort, port, "http")};
        return ports;
    }

    public int getPort() {
        return this.getAttribute(PROPERTY_PORT, 8080);
    }

    public void setPort(int port) {
        this.setAttribute(PROPERTY_PORT, port);
    }

    public static IServer createPreviewServer(String serverName) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"org.eclipse.jst.server.preview.runtime");
            IRuntimeWorkingCopy runtimeCopy = runtimeType.createRuntime("org.eclipse.jst.server.preview.runtime", (IProgressMonitor)monitor);
            IRuntime runtime = runtimeCopy.save(true, (IProgressMonitor)monitor);
            IServerType serverType = ServerCore.findServerType((String)ID);
            IServerWorkingCopy workingCopy = serverType.createServer(ID, null, runtime, (IProgressMonitor)monitor);
            workingCopy.setName(serverName);
            workingCopy.setHost("localhost");
            return workingCopy.save(true, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error creating server", e);
            return null;
        }
    }

    public static IServer findPreviewServer(String id) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getId().equals(id)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String toString() {
        return "PreviewServer";
    }
}

