/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphUtilities;
import org.eclipse.draw2d.graph.HorizontalPlacement;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.graph.SubgraphBoundary;

class CompoundHorizontalPlacement
extends HorizontalPlacement {
    Set entries = new HashSet();

    CompoundHorizontalPlacement() {
    }

    void applyGPrime() {
        super.applyGPrime();
        NodeList subgraphs = ((CompoundDirectedGraph)this.graph).subgraphs;
        int i = 0;
        while (i < subgraphs.size()) {
            Subgraph s = (Subgraph)subgraphs.get(i);
            s.x = s.left.x;
            s.width = s.right.x + s.right.width - s.x;
            ++i;
        }
    }

    void buildRankSeparators(RankList ranks) {
        CompoundDirectedGraph g = (CompoundDirectedGraph)this.graph;
        int row = 0;
        while (row < g.ranks.size()) {
            Rank rank = g.ranks.getRank(row);
            Node n = null;
            Node prev = null;
            int j = 0;
            while (j < rank.size()) {
                n = rank.getNode(j);
                if (prev == null) {
                    Node left = this.addSeparatorsLeft(n, null);
                    if (left != null) {
                        Edge e = new Edge(this.graphLeft, this.getPrime(left), 0, 0);
                        this.prime.edges.add(e);
                        e.delta = this.graph.getPadding((Node)n).left + this.graph.getMargin().left;
                    }
                } else {
                    Subgraph s = GraphUtilities.getCommonAncestor(prev, n);
                    Node left = this.addSeparatorsRight(prev, s);
                    Node right = this.addSeparatorsLeft(n, s);
                    this.createEdge(left, right);
                }
                prev = n;
                ++j;
            }
            if (n != null) {
                this.addSeparatorsRight(n, null);
            }
            ++row;
        }
    }

    void createEdge(Node left, Node right) {
        LeftRight entry = new LeftRight(left, right);
        if (this.entries.contains(entry)) {
            return;
        }
        this.entries.add(entry);
        int separation = left.width + this.graph.getPadding((Node)left).right + this.graph.getPadding((Node)right).left;
        this.prime.edges.add(new Edge(this.getPrime(left), this.getPrime(right), separation, 0));
    }

    Node addSeparatorsLeft(Node n, Subgraph graph) {
        Subgraph parent = n.getParent();
        while (parent != graph && parent != null) {
            this.createEdge(this.getLeft(parent), n);
            n = parent.left;
            parent = parent.getParent();
        }
        return n;
    }

    Node addSeparatorsRight(Node n, Subgraph graph) {
        Subgraph parent = n.getParent();
        while (parent != graph && parent != null) {
            this.createEdge(n, this.getRight(parent));
            n = parent.right;
            parent = parent.getParent();
        }
        return n;
    }

    Node getLeft(Subgraph s) {
        if (s.left == null) {
            s.left = new SubgraphBoundary(s, this.graph.getPadding(s), 1);
            s.left.rank = (s.head.rank + s.tail.rank) / 2;
            Node head = this.getPrime(s.head);
            Node tail = this.getPrime(s.tail);
            Node left = this.getPrime(s.left);
            Node right = this.getPrime(this.getRight(s));
            this.prime.edges.add(new Edge(left, right, s.width, 0));
            this.prime.edges.add(new Edge(left, head, 0, 1));
            this.prime.edges.add(new Edge(head, right, 0, 1));
            this.prime.edges.add(new Edge(left, tail, 0, 1));
            this.prime.edges.add(new Edge(tail, right, 0, 1));
        }
        return s.left;
    }

    Node getRight(Subgraph s) {
        if (s.right == null) {
            s.right = new SubgraphBoundary(s, this.graph.getPadding(s), 3);
            s.right.rank = (s.head.rank + s.tail.rank) / 2;
        }
        return s.right;
    }

    Node getPrime(Node n) {
        Node nPrime = this.get(n);
        if (nPrime == null) {
            nPrime = new Node(n);
            this.prime.nodes.add(nPrime);
            this.map(n, nPrime);
        }
        return nPrime;
    }

    public void visit(DirectedGraph g) {
        super.visit(g);
    }

    class LeftRight {
        Object left;
        Object right;

        LeftRight(Object l, Object r) {
            this.left = l;
            this.right = r;
        }

        public boolean equals(Object obj) {
            LeftRight entry = (LeftRight)obj;
            return entry.left.equals(this.left) && entry.right.equals(this.right);
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }
    }
}

