/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.draw2d.text.TextLayout;
import org.eclipse.swt.graphics.Font;

public class ParagraphTextLayout
extends TextLayout {
    public static final int WORD_WRAP_HARD = 0;
    public static final int WORD_WRAP_SOFT = 1;
    public static final int WORD_WRAP_TRUNCATE = 2;
    private int wrappingStyle = 0;

    public ParagraphTextLayout(TextFlow flow) {
        super(flow);
    }

    public ParagraphTextLayout(TextFlow flow, int style) {
        this(flow);
        this.wrappingStyle = style;
    }

    private String[] getSegments(String text, int[] levelInfo) {
        int endOffset;
        if (levelInfo.length == 1) {
            return new String[]{text};
        }
        String[] result = new String[levelInfo.length / 2 + 1];
        int beginOffset = 0;
        int i = 0;
        while (i < result.length - 1) {
            endOffset = levelInfo[i * 2 + 1];
            result[i] = text.substring(beginOffset, endOffset);
            beginOffset = endOffset;
            ++i;
        }
        endOffset = text.length();
        result[i] = text.substring(beginOffset, endOffset);
        return result;
    }

    protected void layout() {
        TextFragmentBox fragment;
        int[] nArray;
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        int offset = 0;
        FlowContext context = this.getContext();
        List fragments = textFlow.getFragments();
        Font font = textFlow.getFont();
        int fragIndex = 0;
        int advance = 0;
        if (textFlow.getBidiInfo() == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = textFlow.getBidiInfo().levelInfo;
        }
        int[] levelInfo = nArray;
        String[] segments = this.getSegments(textFlow.getText(), levelInfo);
        FlowBorder border = null;
        if (textFlow.getBorder() instanceof FlowBorder) {
            border = (FlowBorder)textFlow.getBorder();
        }
        SegmentLookahead lookahead = new SegmentLookahead(segments, border == null ? 0 : border.getRightMargin());
        if (border != null) {
            fragment = this.getFragment(fragIndex++, fragments);
            fragment.setBidiLevel(levelInfo[0]);
            fragment.setTruncated(false);
            fragment.length = -1;
            fragment.offset = -1;
            fragment.setWidth(border.getLeftMargin() + border.getInsets((IFigure)textFlow).left);
            if (context.getRemainingLineWidth() < fragment.getWidth() + lookahead.getWidth()) {
                context.endLine();
            }
            context.addToCurrentLine(fragment);
        }
        FlowUtilities flowUtilities = textFlow.getFlowUtilities();
        int seg = 0;
        while (seg < segments.length) {
            String segment = segments[seg];
            lookahead.setIndex(seg);
            do {
                fragment = this.getFragment(fragIndex++, fragments);
                fragment.offset = offset;
                fragment.setBidiLevel(levelInfo[seg * 2]);
                advance = flowUtilities.wrapFragmentInContext(fragment, segment, context, lookahead, font, this.wrappingStyle);
                segment = segment.substring(advance);
                offset += advance;
                if (segment.length() <= 0 && fragment.length >= advance && !fragment.isTruncated()) continue;
                context.endLine();
            } while (segment.length() > 0 || !fragment.isTruncated() && fragment.length < advance);
            ++seg;
        }
        if (border != null) {
            fragment = this.getFragment(fragIndex++, fragments);
            fragment.setBidiLevel(levelInfo[0]);
            fragment.setTruncated(false);
            fragment.length = -1;
            fragment.offset = -1;
            fragment.setWidth(border.getRightMargin() + border.getInsets((IFigure)textFlow).right);
            context.addToCurrentLine(fragment);
        }
        while (fragIndex < fragments.size()) {
            fragments.remove(fragments.size() - 1);
        }
    }

    class SegmentLookahead
    implements FlowUtilities.LookAhead {
        private int seg = -1;
        private String[] segs;
        private int[] width;
        private final int trailingBorderSize;

        SegmentLookahead(String[] segs, int trailingBorderSize) {
            this.segs = segs;
            this.trailingBorderSize = trailingBorderSize;
        }

        public int getWidth() {
            if (this.width == null) {
                this.width = new int[1];
                int startingIndex = this.seg + 1;
                TextFlow textFlow = (TextFlow)ParagraphTextLayout.this.getFlowFigure();
                if (startingIndex == this.segs.length) {
                    this.width[0] = this.width[0] + this.trailingBorderSize;
                    ParagraphTextLayout.this.getContext().getWidthLookahead(textFlow, this.width);
                } else {
                    String rest = this.segs[startingIndex];
                    int k = startingIndex + 1;
                    while (k < this.segs.length) {
                        rest = String.valueOf(rest) + this.segs[k];
                        ++k;
                    }
                    if (!textFlow.addLeadingWordWidth(rest, this.width)) {
                        this.width[0] = this.width[0] + this.trailingBorderSize;
                        ParagraphTextLayout.this.getContext().getWidthLookahead(textFlow, this.width);
                    }
                }
            }
            return this.width[0];
        }

        public void setIndex(int value) {
            this.seg = value;
            this.width = null;
        }
    }
}

