/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.generator;

import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;

public class GenClassGeneratorAdapter
extends GenBaseGeneratorAdapter {
    protected static final int CLASS_ID = 0;
    protected static final int ITEM_PROVIDER_ID = 1;
    protected static final int TEST_CASE_ID = 2;
    private static final AbstractGeneratorAdapter.JETEmitterDescriptor[] JET_EMITTER_DESCRIPTORS = new AbstractGeneratorAdapter.JETEmitterDescriptor[]{new AbstractGeneratorAdapter.JETEmitterDescriptor("model/Class.javajet", "org.eclipse.emf.codegen.ecore.templates.model.Class"), new AbstractGeneratorAdapter.JETEmitterDescriptor("edit/ItemProvider.javajet", "org.eclipse.emf.codegen.ecore.templates.edit.ItemProvider"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model.tests/TestCase.javajet", "org.eclipse.emf.codegen.ecore.templates.model.tests.TestCase")};
    protected static final int ITEM_ICON_ID = 0;
    protected static final int CREATE_CHILD_ICON_ID = 1;
    private static final String[] INPUT_PATH_NAMES = new String[]{"edit/Item.gif", "edit/CreateChild.gif"};

    protected AbstractGeneratorAdapter.JETEmitterDescriptor[] getJETEmitterDescriptors() {
        return JET_EMITTER_DESCRIPTORS;
    }

    protected String[] getInputPathNames() {
        return INPUT_PATH_NAMES;
    }

    public GenClassGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
        super(generatorAdapterFactory);
    }

    public Object getGenerateParent(Object object, Object projectType) {
        return this.getParent(object);
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        monitor.beginTask("", 3);
        GenClass genClass = (GenClass)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{genClass.getFormattedName()});
        monitor.subTask(this.message);
        GenModel genModel = genClass.getGenModel();
        this.ensureProjectExists(genModel.getModelDirectory(), genClass, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateInterface(genClass, monitor);
        this.generateClass(genClass, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateInterface(GenClass genClass, Monitor monitor) {
        GenModel genModel = genClass.getGenModel();
        GenPackage genPackage = genClass.getGenPackage();
        if (!(genClass.isExternalInterface() || genModel.isSuppressInterfaces() && !genClass.isInterface())) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{String.valueOf(genPackage.getInterfacePackageName()) + "." + genClass.getInterfaceName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getInterfacePackageName(), genClass.getInterfaceName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genClass, Boolean.TRUE, Boolean.FALSE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateClass(GenClass genClass, Monitor monitor) {
        GenModel genModel = genClass.getGenModel();
        GenPackage genPackage = genClass.getGenPackage();
        if (!genClass.isInterface()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genClass.getQualifiedClassName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getClassPackageName(), genClass.getClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genClass, genModel.isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected Diagnostic generateEdit(Object object, Monitor monitor) {
        GenClass genClass = (GenClass)object;
        monitor.beginTask("", 3 + this.countCreateChildIcons(genClass));
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingProvider_message", new Object[]{genClass.getFormattedName()});
        monitor.subTask(this.message);
        GenModel genModel = genClass.getGenModel();
        this.ensureProjectExists(genModel.getEditDirectory(), genClass, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateItemProvider(genClass, monitor);
        this.generateItemIcon(genClass, monitor);
        this.generateCreateChildIcons(genClass, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateItemProvider(GenClass genClass, Monitor monitor) {
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genClass.getQualifiedProviderClassName()});
        monitor.subTask(this.message);
        this.generateJava(genClass.getGenModel().getEditDirectory(), genClass.getGenPackage().getProviderPackageName(), genClass.getProviderClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 1), null, this.createMonitor(monitor, 1));
    }

    protected void generateItemIcon(GenClass genClass, Monitor monitor) {
        if (genClass.isImage()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemIcon_message", new Object[]{genClass.getItemIconFileName()});
            monitor.subTask(this.message);
            this.generateGIF(genClass.getItemIconFileName(), this.getGIFEmitter(this.getInputPathNames(), 0), genClass.getName(), null, false, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected int countCreateChildIcons(GenClass genClass) {
        int result = 0;
        for (GenFeature feature : genClass.getAllCreateChildFeaturesIncludingDelegation()) {
            result += genClass.getChildrenClasses(feature).size();
        }
        return result;
    }

    protected void generateCreateChildIcons(GenClass genClass, Monitor monitor) {
        GenModel genModel = genClass.getGenModel();
        if (genModel.isCreationCommands() && genModel.isCreationIcons()) {
            for (GenFeature feature : genClass.getAllCreateChildFeaturesIncludingDelegation()) {
                for (GenClass childClass : genClass.getChildrenClasses(feature)) {
                    this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCreateChildIcon_message", new Object[]{genClass.getCreateChildIconFileName(feature, childClass)});
                    monitor.subTask(this.message);
                    this.generateGIF(genClass.getCreateChildIconFileName(feature, childClass), this.getGIFEmitter(this.getInputPathNames(), 1), genClass.getName(), childClass.getName(), false, this.createMonitor(monitor, 1));
                }
            }
        } else {
            monitor.worked(this.countCreateChildIcons(genClass));
        }
    }

    protected Diagnostic generateTests(Object object, Monitor monitor) {
        monitor.beginTask("", 2);
        GenClass genClass = (GenClass)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingTestCase_message", new Object[]{genClass.getFormattedName()});
        monitor.subTask(this.message);
        GenModel genModel = genClass.getGenModel();
        this.ensureProjectExists(genModel.getTestsDirectory(), genClass, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateTestCase(genClass, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateTestCase(GenClass genClass, Monitor monitor) {
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genClass.getQualifiedTestCaseClassName()});
        monitor.subTask(this.message);
        this.generateJava(genClass.getGenModel().getTestsDirectory(), genClass.getGenPackage().getTestsPackageName(), genClass.getTestCaseClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 2), null, this.createMonitor(monitor, 1));
    }
}

