/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.IJpaUiFactory;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.PlatformRegistry;
import org.eclipse.jpt.ui.internal.details.BaseJpaDetailsPage;
import org.eclipse.jpt.ui.internal.details.IJpaComposite;
import org.eclipse.jpt.ui.internal.java.details.IAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeDetailsPage
extends BaseJpaDetailsPage {
    private IPersistentAttribute attribute;
    private IAttributeMapping attributeMapping;
    private Adapter persistentAttributeListener = this.buildAttributeListener();
    private String currentMappingKey;
    private CComboViewer mappingCombo;
    private Map<String, IJpaComposite<IAttributeMapping>> mappingComposites = new HashMap<String, IJpaComposite<IAttributeMapping>>();
    protected PageBook mappingPageBook;
    private IJpaComposite<IAttributeMapping> currentMappingComposite;

    public PersistentAttributeDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, (CommandStack)new BasicCommandStack(), widgetFactory);
    }

    protected IJpaPlatformUi jpaPlatformUi() {
        String platformId = this.getAttribute().jpaPlatform().getId();
        return PlatformRegistry.instance().jpaPlatform(platformId);
    }

    protected IJpaUiFactory jpaUiFactory() {
        return this.jpaPlatformUi().getJpaUiFactory();
    }

    protected abstract ListIterator<IAttributeMappingUiProvider> attributeMappingUiProviders();

    protected abstract ListIterator<IAttributeMappingUiProvider> defaultAttributeMappingUiProviders();

    protected IAttributeMappingUiProvider attributeMappingUiProvider(String key) {
        ListIterator<IAttributeMappingUiProvider> i = this.attributeMappingUiProviders();
        while (i.hasNext()) {
            IAttributeMappingUiProvider provider = i.next();
            if (provider.attributeMappingKey() != key) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported attribute mapping UI provider key: ");
    }

    protected abstract IAttributeMappingUiProvider defaultAttributeMappingUiProvider(String var1);

    private Adapter buildAttributeListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PersistentAttributeDetailsPage.this.persistentAttributeChanged(notification);
            }
        };
    }

    protected void persistentAttributeChanged(Notification notification) {
        switch (notification.getFeatureID(IPersistentAttribute.class)) {
            case 0: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PersistentAttributeDetailsPage.this.populate();
                    }
                });
            }
        }
    }

    protected Label buildMappingLabel(Composite parent) {
        return this.getWidgetFactory().createLabel(parent, JptUiMessages.PersistentAttributePage_mapAs);
    }

    protected CComboViewer buildMappingCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.mappingCombo = new CComboViewer(combo);
        this.mappingCombo.setContentProvider(this.buildContentProvider());
        this.mappingCombo.setLabelProvider(this.buildLabelProvider());
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistentAttributeDetailsPage.this.mappingChanged(event);
            }
        });
        return this.mappingCombo;
    }

    private IContentProvider buildContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                return PersistentAttributeDetailsPage.this.attributeMappingUiProvidersFor((IPersistentAttribute)inputElement);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected abstract IAttributeMappingUiProvider[] attributeMappingUiProvidersFor(IPersistentAttribute var1);

    private IBaseLabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((IAttributeMappingUiProvider)element).label();
            }
        };
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        this.mappingPageBook = new PageBook(parent, 0);
        return this.mappingPageBook;
    }

    protected IJpaComposite<IAttributeMapping> buildMappingComposite(PageBook pageBook, String key) {
        if (this.attributeMapping == null || this.attributeMapping.isDefault()) {
            return this.defaultAttributeMappingUiProvider(key).buildAttributeMappingComposite(this.jpaUiFactory(), (Composite)pageBook, this.commandStack, this.getWidgetFactory());
        }
        return this.attributeMappingUiProvider(key).buildAttributeMappingComposite(this.jpaUiFactory(), (Composite)pageBook, this.commandStack, this.getWidgetFactory());
    }

    void mappingChanged(SelectionChangedEvent event) {
        if (this.isPopulating()) {
            return;
        }
        if (event.getSelection() instanceof StructuredSelection) {
            IAttributeMappingUiProvider provider = (IAttributeMappingUiProvider)((StructuredSelection)event.getSelection()).getFirstElement();
            String key = CollectionTools.contains(this.defaultAttributeMappingUiProviders(), (Object)provider) ? null : provider.attributeMappingKey();
            this.attribute.setSpecifiedMappingKey(key);
        }
    }

    @Override
    protected void doPopulate(IJpaContentNode persistentAttributeNode) {
        this.attribute = (IPersistentAttribute)persistentAttributeNode;
        this.populateMappingComboAndPage();
    }

    @Override
    protected void doPopulate() {
        this.populateMappingComboAndPage();
    }

    @Override
    protected void engageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().add((Object)this.persistentAttributeListener);
        }
    }

    @Override
    protected void disengageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().remove((Object)this.persistentAttributeListener);
        }
    }

    private void populateMappingComboAndPage() {
        if (this.attribute == null) {
            this.attributeMapping = null;
            this.currentMappingKey = null;
            this.mappingCombo.setInput(null);
            this.mappingCombo.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.currentMappingComposite != null) {
                this.currentMappingComposite.populate(null);
                this.currentMappingComposite = null;
            }
            return;
        }
        this.attributeMapping = this.attribute.getMapping();
        this.setComboData();
        this.populateMappingPage(this.attributeMapping == null ? null : this.attributeMapping.getKey());
    }

    private void populateMappingPage(String mappingKey) {
        if (this.currentMappingComposite != null) {
            if (mappingKey == this.currentMappingKey) {
                if (this.currentMappingComposite != null) {
                    this.currentMappingComposite.populate(this.attributeMapping);
                    return;
                }
            } else {
                this.currentMappingComposite.populate(null);
            }
        }
        this.currentMappingKey = mappingKey;
        IJpaComposite<IAttributeMapping> composite = this.mappingCompositeFor(mappingKey);
        this.mappingPageBook.showPage(composite.getControl());
        this.currentMappingComposite = composite;
        this.currentMappingComposite.populate(this.attributeMapping);
    }

    private void setComboData() {
        if (this.attribute != this.mappingCombo.getInput()) {
            this.mappingCombo.setInput(this.attribute);
        }
        if (this.attributeMapping == null || this.attributeMapping.isDefault()) {
            this.mappingCombo.setSelection((ISelection)new StructuredSelection(this.mappingCombo.getElementAt(0)));
        } else {
            IAttributeMappingUiProvider provider = this.attributeMappingUiProvider(this.attribute.mappingKey());
            if (provider != null && !provider.equals(((StructuredSelection)this.mappingCombo.getSelection()).getFirstElement())) {
                this.mappingCombo.setSelection((ISelection)new StructuredSelection((Object)provider));
            }
        }
    }

    private IJpaComposite<IAttributeMapping> mappingCompositeFor(String key) {
        IJpaComposite<IAttributeMapping> composite = this.mappingComposites.get(key);
        if (composite != null) {
            return composite;
        }
        composite = this.buildMappingComposite(this.mappingPageBook, key);
        if (composite != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    @Override
    public void dispose() {
        this.disengageListeners();
        for (IJpaComposite<IAttributeMapping> composite : this.mappingComposites.values()) {
            composite.dispose();
        }
        super.dispose();
    }

    public IPersistentAttribute getAttribute() {
        return this.attribute;
    }
}

