/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.details.BaseJpaDetailsPage;
import org.eclipse.jpt.ui.internal.details.IJpaComposite;
import org.eclipse.jpt.ui.internal.java.details.ITypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentTypeDetailsPage
extends BaseJpaDetailsPage {
    private IPersistentType persistentType;
    private Adapter persistentTypeListener = this.buildPersistentTypeListener();
    private String currentMappingKey;
    private CComboViewer typeMappingCombo;
    private Map<String, IJpaComposite<ITypeMapping>> composites = new HashMap<String, IJpaComposite<ITypeMapping>>();
    protected PageBook typeMappingPageBook;
    private IJpaComposite<ITypeMapping> visibleMappingComposite;

    public PersistentTypeDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, (CommandStack)new BasicCommandStack(), widgetFactory);
    }

    protected abstract ListIterator<ITypeMappingUiProvider> typeMappingUiProviders();

    private ITypeMappingUiProvider typeMappingUiProvider(String key) {
        ListIterator<ITypeMappingUiProvider> i = this.typeMappingUiProviders();
        while (i.hasNext()) {
            ITypeMappingUiProvider provider = i.next();
            if (provider.mappingKey() != key) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported type mapping UI provider key: " + key);
    }

    private Adapter buildPersistentTypeListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PersistentTypeDetailsPage.this.persistentTypeChanged(notification);
            }
        };
    }

    private void persistentTypeChanged(Notification notification) {
        switch (notification.getFeatureID(IPersistentType.class)) {
            case 0: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PersistentTypeDetailsPage.this.populate();
                    }
                });
            }
        }
    }

    protected Label buildTypeMappingLabel(Composite parent) {
        return this.getWidgetFactory().createLabel(parent, JptUiMessages.PersistentTypePage_mapAs);
    }

    protected CComboViewer buildTypeMappingCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.typeMappingCombo = new CComboViewer(combo);
        this.typeMappingCombo.setContentProvider(this.buildContentProvider());
        this.typeMappingCombo.setLabelProvider(this.buildLabelProvider());
        this.typeMappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistentTypeDetailsPage.this.typeMappingChanged(event);
            }
        });
        return this.typeMappingCombo;
    }

    private IContentProvider buildContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return PersistentTypeDetailsPage.this.persistentType == null ? new String[]{} : CollectionTools.array(PersistentTypeDetailsPage.this.typeMappingUiProviders());
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private IBaseLabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((ITypeMappingUiProvider)element).label();
            }
        };
    }

    protected PageBook buildTypeMappingPageBook(Composite parent) {
        this.typeMappingPageBook = new PageBook(parent, 0);
        return this.typeMappingPageBook;
    }

    private void typeMappingChanged(SelectionChangedEvent event) {
        if (this.isPopulating()) {
            return;
        }
        if (event.getSelection() instanceof StructuredSelection) {
            ITypeMappingUiProvider provider = (ITypeMappingUiProvider)((StructuredSelection)event.getSelection()).getFirstElement();
            this.persistentType.setMappingKey(provider.mappingKey());
        }
    }

    @Override
    protected void doPopulate(IJpaContentNode persistentTypeNode) {
        this.persistentType = (IPersistentType)persistentTypeNode;
        this.populateMappingComboAndPage();
    }

    @Override
    protected void doPopulate() {
        this.populateMappingComboAndPage();
    }

    @Override
    protected void engageListeners() {
        if (this.persistentType != null) {
            this.persistentType.eAdapters().add((Object)this.persistentTypeListener);
        }
    }

    @Override
    protected void disengageListeners() {
        if (this.persistentType != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeListener);
        }
    }

    private void populateMappingComboAndPage() {
        if (this.persistentType == null) {
            this.currentMappingKey = null;
            this.typeMappingCombo.setInput(null);
            this.typeMappingCombo.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.visibleMappingComposite != null) {
                this.visibleMappingComposite.populate(null);
                this.visibleMappingComposite = null;
            }
            return;
        }
        String mappingKey = this.persistentType.getMapping().getKey();
        this.setComboData(mappingKey);
        this.populateMappingPage(mappingKey);
    }

    private void populateMappingPage(String mappingKey) {
        if (this.visibleMappingComposite != null) {
            if (mappingKey == this.currentMappingKey) {
                if (this.visibleMappingComposite != null) {
                    this.visibleMappingComposite.populate(this.persistentType.getMapping());
                    return;
                }
            } else {
                this.visibleMappingComposite.populate(null);
            }
        }
        this.currentMappingKey = mappingKey;
        IJpaComposite<ITypeMapping> mappingComposite = this.mappingCompositeFor(mappingKey);
        this.typeMappingPageBook.showPage(mappingComposite.getControl());
        this.visibleMappingComposite = mappingComposite;
        this.visibleMappingComposite.populate(this.persistentType.getMapping());
    }

    private void setComboData(String mappingKey) {
        ITypeMappingUiProvider provider;
        if (this.persistentType != this.typeMappingCombo.getInput()) {
            this.typeMappingCombo.setInput(this.persistentType);
        }
        if (!(provider = this.typeMappingUiProvider(mappingKey)).equals(((StructuredSelection)this.typeMappingCombo.getSelection()).getFirstElement())) {
            this.typeMappingCombo.setSelection((ISelection)new StructuredSelection((Object)provider));
        }
    }

    private IJpaComposite<ITypeMapping> mappingCompositeFor(String key) {
        IJpaComposite<ITypeMapping> mappingComposite = this.composites.get(key);
        if (mappingComposite != null) {
            return mappingComposite;
        }
        mappingComposite = this.buildMappingComposite(this.typeMappingPageBook, key);
        if (mappingComposite != null) {
            this.composites.put(key, mappingComposite);
        }
        return mappingComposite;
    }

    protected IJpaComposite<ITypeMapping> buildMappingComposite(PageBook pageBook, String key) {
        return this.typeMappingUiProvider(key).buildPersistentTypeMappingComposite((Composite)pageBook, this.commandStack, this.getWidgetFactory());
    }

    @Override
    public void dispose() {
        this.disengageListeners();
        Iterator<IJpaComposite<ITypeMapping>> i = this.composites.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        super.dispose();
    }

    public IPersistentType getPersistentType() {
        return this.persistentType;
    }
}

