/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.List;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EmbeddedAttributeOverridesComposite
extends BaseJpaComposite {
    private ListViewer listViewer;
    private IEmbedded embedded;
    private Adapter embeddedListener = this.buildEmbeddedListener();
    private IAttributeOverride attributeOverride;
    private Adapter attributeOverrideListener = this.buildAttributeOverrideListener();
    protected ColumnComposite columnComposite;
    private Button overrideDefaultButton;

    public EmbeddedAttributeOverridesComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildEmbeddedListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                EmbeddedAttributeOverridesComposite.this.embeddedChanged(notification);
            }
        };
    }

    private Adapter buildAttributeOverrideListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                EmbeddedAttributeOverridesComposite.this.attributeOverrideChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group attributeOverridesGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.AttributeOverridesComposite_attributeOverrides);
        attributeOverridesGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        attributeOverridesGroup.setLayoutData((Object)gridData);
        this.listViewer = this.buildAttributeOverridesListViewer((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.listViewer.getList(), "org.eclipse.jpt.ui.mapping_embeddedAttributeOverrides");
        this.overrideDefaultButton = this.getWidgetFactory().createButton((Composite)attributeOverridesGroup, "Override Default", 32);
        this.overrideDefaultButton.addSelectionListener(this.buildOverrideDefaultSelectionListener());
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.overrideDefaultButton.setLayoutData((Object)gridData);
        this.columnComposite = new ColumnComposite((Composite)attributeOverridesGroup, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.columnComposite.getControl().setLayoutData((Object)gridData);
    }

    private SelectionListener buildOverrideDefaultSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmbeddedAttributeOverridesComposite.this.overrideDefaultButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EmbeddedAttributeOverridesComposite.this.overrideDefaultButtonSelected(e);
            }
        };
    }

    private void overrideDefaultButtonSelected(SelectionEvent e) {
        boolean selection = this.overrideDefaultButton.getSelection();
        if (selection) {
            int index = this.embedded.getSpecifiedAttributeOverrides().size();
            IAttributeOverride attributeOverride = this.embedded.createAttributeOverride(index);
            this.embedded.getSpecifiedAttributeOverrides().add((Object)attributeOverride);
            attributeOverride.setName(this.attributeOverride.getName());
            attributeOverride.getColumn().setSpecifiedName(this.attributeOverride.getColumn().getName());
        } else {
            this.embedded.getSpecifiedAttributeOverrides().remove((Object)this.attributeOverride);
        }
    }

    private ListViewer buildAttributeOverridesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildAttributeOverridesLabelProvider());
        listViewer.setContentProvider(this.buildAttributeOverridesContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EmbeddedAttributeOverridesComposite.this.attributeOverridesListSelectionChanged(event);
            }
        });
        return listViewer;
    }

    protected void attributeOverridesListSelectionChanged(SelectionChangedEvent event) {
        if (((StructuredSelection)event.getSelection()).isEmpty()) {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
            this.overrideDefaultButton.setSelection(false);
            this.overrideDefaultButton.setEnabled(false);
        } else {
            this.attributeOverride = this.getSelectedAttributeOverride();
            boolean specifiedOverride = this.embedded.getSpecifiedAttributeOverrides().contains((Object)this.attributeOverride);
            this.overrideDefaultButton.setSelection(specifiedOverride);
            this.columnComposite.populate((EObject)this.attributeOverride.getColumn());
            this.columnComposite.enableWidgets(specifiedOverride);
            this.overrideDefaultButton.setEnabled(true);
        }
    }

    private ILabelProvider buildAttributeOverridesLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((IAttributeOverride)element).getName();
            }
        };
    }

    private IContentProvider buildAttributeOverridesContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IEmbedded)inputElement).getAttributeOverrides().toArray();
            }
        };
    }

    private IAttributeOverride getSelectedAttributeOverride() {
        return (IAttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    public void doPopulate(EObject obj) {
        this.embedded = (IEmbedded)obj;
        if (this.embedded == null) {
            this.attributeOverride = null;
            this.columnComposite.populate(null);
            this.listViewer.setInput(null);
            return;
        }
        if (this.listViewer.getInput() != this.embedded) {
            this.listViewer.setInput((Object)this.embedded);
        }
        if (!this.embedded.getAttributeOverrides().isEmpty()) {
            if (this.listViewer.getSelection().isEmpty()) {
                IAttributeOverride attributeOverride = (IAttributeOverride)this.embedded.getAttributeOverrides().get(0);
                this.listViewer.setSelection((ISelection)new StructuredSelection((Object)attributeOverride));
            } else {
                this.columnComposite.enableWidgets(true);
                this.columnComposite.populate((EObject)((IAttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement()).getColumn());
            }
        } else {
            this.columnComposite.populate(null);
            this.columnComposite.enableWidgets(false);
        }
    }

    protected void doPopulate() {
        this.columnComposite.doPopulate();
    }

    protected void engageListeners() {
        if (this.embedded != null) {
            this.embedded.eAdapters().add((Object)this.embeddedListener);
            for (IAttributeOverride attributeOverride : this.embedded.getAttributeOverrides()) {
                attributeOverride.eAdapters().add((Object)this.attributeOverrideListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.embedded != null) {
            this.embedded.eAdapters().remove((Object)this.embeddedListener);
            for (IAttributeOverride attributeOverride : this.embedded.getAttributeOverrides()) {
                attributeOverride.eAdapters().remove((Object)this.attributeOverrideListener);
            }
        }
    }

    protected void embeddedChanged(Notification notification) {
        switch (notification.getFeatureID(IEmbedded.class)) {
            case 1: 
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (EmbeddedAttributeOverridesComposite.this.listViewer.getList().isDisposed()) {
                            return;
                        }
                        EmbeddedAttributeOverridesComposite.this.listViewer.refresh();
                        EmbeddedAttributeOverridesComposite.this.columnComposite.enableWidgets(!EmbeddedAttributeOverridesComposite.this.listViewer.getSelection().isEmpty());
                        if (EmbeddedAttributeOverridesComposite.this.listViewer.getSelection().isEmpty()) {
                            EmbeddedAttributeOverridesComposite.this.columnComposite.populate(null);
                        }
                    }
                });
                if (notification.getEventType() == 3) {
                    ((IAttributeOverride)notification.getNewValue()).eAdapters().add((Object)this.attributeOverrideListener);
                    final Object newValue = notification.getNewValue();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (EmbeddedAttributeOverridesComposite.this.listViewer.getList().isDisposed()) {
                                return;
                            }
                            EmbeddedAttributeOverridesComposite.this.listViewer.setSelection((ISelection)new StructuredSelection(newValue));
                        }
                    });
                    break;
                }
                if (notification.getEventType() == 5) {
                    List addedList = (List)notification.getNewValue();
                    for (IAttributeOverride override : addedList) {
                        override.eAdapters().add((Object)this.attributeOverrideListener);
                    }
                } else {
                    if (notification.getEventType() == 4) {
                        ((IAttributeOverride)notification.getOldValue()).eAdapters().remove((Object)this.attributeOverrideListener);
                        break;
                    }
                    if (notification.getEventType() != 6) break;
                    List removedList = (List)notification.getOldValue();
                    for (IAttributeOverride override : removedList) {
                        override.eAdapters().remove((Object)this.attributeOverrideListener);
                    }
                }
                break;
            }
        }
    }

    protected void attributeOverrideChanged(Notification notification) {
        switch (notification.getFeatureID(IAttributeOverride.class)) {
            case 0: {
                final IAttributeOverride attributeOverride = (IAttributeOverride)notification.getNotifier();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EmbeddedAttributeOverridesComposite.this.listViewer.refresh((Object)attributeOverride);
                    }
                });
                break;
            }
        }
    }

    public void dispose() {
        this.columnComposite.dispose();
        super.dispose();
    }
}

