/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EntityNameCombo;
import org.eclipse.jpt.ui.internal.mappings.details.InheritanceComposite;
import org.eclipse.jpt.ui.internal.mappings.details.OverridesComposite;
import org.eclipse.jpt.ui.internal.mappings.details.SecondaryTablesComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EntityComposite
extends BaseJpaComposite {
    private IEntity entity;
    private EntityNameCombo entityNameCombo;
    private TableComposite tableComposite;
    private InheritanceComposite inheritanceComposite;
    private SecondaryTablesComposite secondaryTablesComposite;
    private OverridesComposite attributeOverridesComposite;

    public EntityComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralComposite(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
        Control attributeOverridesControl = this.buildAttributeOverridesComposite(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        attributeOverridesControl.setLayoutData((Object)gridData);
        Control secondaryTablesControl = this.buildSecondaryTablesComposite(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        secondaryTablesControl.setLayoutData((Object)gridData);
        Control inheritanceControl = this.buildInheritanceComposite(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        inheritanceControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralComposite(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        CommonWidgets.buildEntityNameLabel(generalComposite, this.getWidgetFactory());
        this.entityNameCombo = CommonWidgets.buildEntityNameCombo(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.entityNameCombo.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.entityNameCombo.getCombo(), "org.eclipse.jpt.ui.entity_name");
        this.tableComposite = new TableComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.tableComposite.getControl().setLayoutData((Object)gridData);
        return generalComposite;
    }

    private Control buildSecondaryTablesComposite(Composite composite) {
        Section section = this.getWidgetFactory().createSection(composite, 8388866);
        section.setText(JptUiMappingsMessages.SecondaryTablesComposite_secondaryTables);
        Composite client = this.getWidgetFactory().createComposite((Composite)section);
        section.setClient((Control)client);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.secondaryTablesComposite = new SecondaryTablesComposite(client, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.secondaryTablesComposite.getControl().setLayoutData((Object)gridData);
        return section;
    }

    private Control buildInheritanceComposite(Composite composite) {
        Section section = this.getWidgetFactory().createSection(composite, 8388866);
        section.setText(JptUiMappingsMessages.EntityComposite_inheritance);
        Composite inheritanceClient = this.getWidgetFactory().createComposite((Composite)section);
        section.setClient((Control)inheritanceClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        inheritanceClient.setLayout((Layout)layout);
        this.inheritanceComposite = new InheritanceComposite(inheritanceClient, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.inheritanceComposite.getControl().setLayoutData((Object)gridData);
        return section;
    }

    private Control buildAttributeOverridesComposite(Composite composite) {
        Section section = this.getWidgetFactory().createSection(composite, 8388866);
        section.setText(JptUiMappingsMessages.AttributeOverridesComposite_attributeOverrides);
        Composite client = this.getWidgetFactory().createComposite((Composite)section);
        section.setClient((Control)client);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.attributeOverridesComposite = new OverridesComposite(client, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.attributeOverridesComposite.getControl().setLayoutData((Object)gridData);
        return section;
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        this.entityNameCombo.populate(obj);
        this.attributeOverridesComposite.populate(obj);
        this.secondaryTablesComposite.populate(obj);
        this.inheritanceComposite.populate(obj);
        if (this.entity != null) {
            this.tableComposite.populate((EObject)this.entity.getTable());
        } else {
            this.tableComposite.populate(null);
        }
    }

    public void doPopulate() {
        this.entityNameCombo.populate();
        this.tableComposite.populate();
        this.attributeOverridesComposite.populate();
        this.secondaryTablesComposite.populate();
        this.inheritanceComposite.populate();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    public void dispose() {
        this.entityNameCombo.dispose();
        this.tableComposite.dispose();
        this.attributeOverridesComposite.dispose();
        this.secondaryTablesComposite.dispose();
        this.inheritanceComposite.dispose();
        super.dispose();
    }

    protected IEntity getEntity() {
        return this.entity;
    }
}

