/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.internal.mappings.DiscriminatorType;
import org.eclipse.jpt.core.internal.mappings.IDiscriminatorColumn;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.mappings.InheritanceType;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnsComposite;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class InheritanceComposite
extends BaseJpaComposite {
    private IEntity entity;
    private IDiscriminatorColumn discriminatorColumn;
    private final Adapter entityListener = this.buildEntityListener();
    private final Adapter discriminatorColumnListener = this.buildDiscriminatorColumnListener();
    private CComboViewer strategyViewer;
    private CCombo columnCombo;
    private CComboViewer discriminatorTypeViewer;
    private CCombo discriminatorValueCombo;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private ConnectionProfile connectionProfile;
    private PrimaryKeyJoinColumnsComposite pkJoinColumnsComposite;

    public InheritanceComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildEntityListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                InheritanceComposite.this.entityChanged(notification);
            }
        };
    }

    private Adapter buildDiscriminatorColumnListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                InheritanceComposite.this.discriminatorColumnChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
            }

            public void closed(ConnectionProfile profile) {
                InheritanceComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (InheritanceComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        InheritanceComposite.this.populateColumnCombo();
                    }
                });
            }

            public void modified(ConnectionProfile profile) {
                InheritanceComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (InheritanceComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        InheritanceComposite.this.populateColumnCombo();
                    }
                });
            }

            public boolean okToClose(ConnectionProfile profile) {
                return true;
            }

            public void opened(ConnectionProfile profile) {
                InheritanceComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (InheritanceComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        InheritanceComposite.this.populateColumnCombo();
                    }
                });
            }

            public void databaseChanged(ConnectionProfile profile, Database database) {
            }

            public void schemaChanged(ConnectionProfile profile, Schema schema) {
            }

            public void tableChanged(ConnectionProfile profile, final Table table) {
                InheritanceComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (table == InheritanceComposite.this.getDbTable() && !InheritanceComposite.this.getControl().isDisposed()) {
                            InheritanceComposite.this.populateColumnCombo();
                        }
                    }
                });
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.InheritanceComposite_strategy);
        this.strategyViewer = this.buildStrategyCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.strategyViewer.getCombo(), "org.eclipse.jpt.ui.entity_inheritanceStrategy");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.DiscriminatorColumnComposite_column);
        this.columnCombo = this.buildColumnCombo(composite);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.columnCombo, "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorColumn");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.DiscriminatorColumnComposite_discriminatorType);
        this.discriminatorTypeViewer = this.buildDiscriminatorTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.discriminatorTypeViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.discriminatorTypeViewer.getCombo(), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorType");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.InheritanceComposite_discriminatorValue);
        this.discriminatorValueCombo = this.buildDiscriminatorValueCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.discriminatorValueCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.discriminatorValueCombo, "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorValue");
        this.pkJoinColumnsComposite = new PrimaryKeyJoinColumnsComposite(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsComposite.getControl().setLayoutData((Object)gridData);
    }

    private CComboViewer buildStrategyCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        CComboViewer strategyViewer = new CComboViewer(combo);
        strategyViewer.setLabelProvider(this.buildStrategyLabelProvider());
        strategyViewer.add(InheritanceType.VALUES.toArray());
        strategyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InheritanceComposite.this.strategySelectionChanged(event.getSelection());
            }
        });
        return strategyViewer;
    }

    private IBaseLabelProvider buildStrategyLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == InheritanceType.DEFAULT) {
                    return NLS.bind((String)JptUiMappingsMessages.InheritanceComposite_default, (Object)"Single Table");
                }
                return super.getText(element);
            }
        };
    }

    void strategySelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            InheritanceType inheritanceType = (InheritanceType)((IStructuredSelection)selection).getFirstElement();
            if (!this.entity.getInheritanceStrategy().equals((Object)inheritanceType)) {
                this.entity.setInheritanceStrategy(inheritanceType);
            }
        }
    }

    private CCombo buildColumnCombo(Composite parent) {
        final CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InheritanceComposite.this.isPopulating()) {
                    return;
                }
                String tableText = ((CCombo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (InheritanceComposite.this.discriminatorColumn.getSpecifiedName() == null || InheritanceComposite.this.discriminatorColumn.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (InheritanceComposite.this.discriminatorColumn.getSpecifiedName() == null && tableText != null) {
                    InheritanceComposite.this.discriminatorColumn.setSpecifiedName(tableText);
                }
                if (InheritanceComposite.this.discriminatorColumn.getSpecifiedName() != null && !InheritanceComposite.this.discriminatorColumn.getSpecifiedName().equals(tableText)) {
                    InheritanceComposite.this.discriminatorColumn.setSpecifiedName(tableText);
                }
            }
        });
        return combo;
    }

    private CComboViewer buildDiscriminatorTypeCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        CComboViewer discriminatorTypeViewer = new CComboViewer(combo);
        discriminatorTypeViewer.setLabelProvider(this.buildDiscriminatorTypeLabelProvider());
        discriminatorTypeViewer.add(DiscriminatorType.VALUES.toArray());
        discriminatorTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InheritanceComposite.this.discriminatorTypeSelectionChanged(event.getSelection());
            }
        });
        return discriminatorTypeViewer;
    }

    private IBaseLabelProvider buildDiscriminatorTypeLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == DiscriminatorType.DEFAULT) {
                    return NLS.bind((String)JptUiMappingsMessages.InheritanceComposite_defaultDiscriminatorType, (Object)"String");
                }
                return super.getText(element);
            }
        };
    }

    void discriminatorTypeSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            DiscriminatorType discriminatorType = (DiscriminatorType)((IStructuredSelection)selection).getFirstElement();
            if (!this.discriminatorColumn.getDiscriminatorType().equals((Object)discriminatorType)) {
                this.discriminatorColumn.setDiscriminatorType(discriminatorType);
            }
        }
    }

    private CCombo buildDiscriminatorValueCombo(Composite parent) {
        final CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InheritanceComposite.this.isPopulating()) {
                    return;
                }
                String discriminatorValue = InheritanceComposite.this.entity.getSpecifiedDiscriminatorValue();
                String value = ((CCombo)e.getSource()).getText();
                if (value.equals("")) {
                    value = null;
                    if (discriminatorValue == null || discriminatorValue.equals("")) {
                        return;
                    }
                }
                if (value != null && combo.getItemCount() > 0 && value.equals(combo.getItem(0))) {
                    value = null;
                }
                if (discriminatorValue == null || !discriminatorValue.equals(value)) {
                    InheritanceComposite.this.entity.setSpecifiedDiscriminatorValue(value);
                }
            }
        });
        return combo;
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        if (this.entity != null) {
            this.discriminatorColumn = this.entity.getDiscriminatorColumn();
            this.populateColumnCombo();
            this.popuplateDiscriminatorTypeComboViewer();
            this.populateStrategyComboViewer();
            this.populateDiscriminatorValueCombo();
            this.pkJoinColumnsComposite.populate((EObject)this.entity);
        } else {
            this.discriminatorColumn = null;
            this.connectionProfile = null;
        }
    }

    public void doPopulate() {
        if (this.entity != null) {
            this.populateColumnCombo();
        }
    }

    protected void engageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().add((Object)this.entityListener);
            this.discriminatorColumn.eAdapters().add((Object)this.discriminatorColumnListener);
            this.addConnectionListener();
        }
    }

    protected void disengageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().remove((Object)this.entityListener);
            this.removeConnectionListener();
            this.discriminatorColumn.eAdapters().remove((Object)this.discriminatorColumnListener);
        }
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            this.connectionProfile = this.entity.getJpaProject().connectionProfile();
        }
        return this.connectionProfile;
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }

    private Table getDbTable() {
        return this.entity.primaryDbTable();
    }

    private void populateColumnCombo() {
        this.populateDefaultColumnName();
        if (this.getConnectionProfile().isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            Table table = this.getDbTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        } else {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
        }
        this.populateColumnName();
    }

    protected void populateDefaultColumnName() {
        String defaultTableName = this.discriminatorColumn.getDefaultName();
        int selectionIndex = this.columnCombo.getSelectionIndex();
        this.columnCombo.setItem(0, NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName));
        if (selectionIndex == 0) {
            this.columnCombo.clearSelection();
            this.columnCombo.select(0);
        }
    }

    protected void populateColumnName() {
        String tableName = this.discriminatorColumn.getSpecifiedName();
        String defaultName = this.discriminatorColumn.getDefaultName();
        if (tableName != null) {
            if (!this.columnCombo.getText().equals(tableName)) {
                this.columnCombo.setText(tableName);
            }
        } else if (!this.columnCombo.getText().equals(NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultName))) {
            this.columnCombo.select(0);
        }
    }

    private void popuplateDiscriminatorTypeComboViewer() {
        if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.DEFAULT) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.DEFAULT) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.DEFAULT));
            }
        } else if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.CHAR) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.CHAR) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.CHAR));
            }
        } else if (this.discriminatorColumn.getDiscriminatorType() == DiscriminatorType.INTEGER) {
            if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.INTEGER) {
                this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.INTEGER));
            }
        } else if (((StructuredSelection)this.discriminatorTypeViewer.getSelection()).getFirstElement() != DiscriminatorType.STRING) {
            this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)DiscriminatorType.STRING));
        }
    }

    private void populateStrategyComboViewer() {
        if (this.entity.getInheritanceStrategy() == InheritanceType.DEFAULT) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.DEFAULT) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.DEFAULT));
            }
        } else if (this.entity.getInheritanceStrategy() == InheritanceType.JOINED) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.JOINED) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.JOINED));
            }
        } else if (this.entity.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.SINGLE_TABLE) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.SINGLE_TABLE));
            }
        } else if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.TABLE_PER_CLASS) {
            this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.TABLE_PER_CLASS));
        }
    }

    private void populateDiscriminatorValueCombo() {
        String specifiedValue = this.entity.getSpecifiedDiscriminatorValue();
        String defaultValue = this.entity.getDefaultDiscriminatorValue();
        if (this.entity.discriminatorValueIsAllowed()) {
            this.discriminatorValueCombo.setEnabled(true);
            if (this.discriminatorValueCombo.getItemCount() == 0) {
                this.discriminatorValueCombo.add(JptUiMappingsMessages.DiscriminatorColumnComposite_defaultEmpty);
            }
            if (defaultValue != null) {
                this.discriminatorValueCombo.setItem(0, NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultValue));
            } else {
                this.discriminatorValueCombo.setItem(0, JptUiMappingsMessages.DiscriminatorColumnComposite_defaultEmpty);
            }
        } else {
            this.discriminatorValueCombo.setEnabled(false);
            if (this.discriminatorValueCombo.getItemCount() == 1) {
                this.discriminatorValueCombo.setText("");
                this.discriminatorValueCombo.removeAll();
            }
        }
        if (specifiedValue != null) {
            if (!this.discriminatorValueCombo.getText().equals(specifiedValue)) {
                this.discriminatorValueCombo.setText(specifiedValue);
            }
        } else {
            this.discriminatorValueCombo.clearSelection();
            this.discriminatorValueCombo.select(0);
        }
    }

    private void entityChanged(Notification notification) {
        if (notification.getFeatureID(IEntity.class) == 9) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    InheritanceType inheritanceType = InheritanceComposite.this.entity.getInheritanceStrategy();
                    if (((StructuredSelection)InheritanceComposite.this.strategyViewer.getSelection()).getFirstElement() != inheritanceType) {
                        InheritanceComposite.this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)inheritanceType));
                    }
                }
            });
        } else if (notification.getFeatureID(IEntity.class) == 11) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (InheritanceComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    String discriminatorValue = InheritanceComposite.this.entity.getSpecifiedDiscriminatorValue();
                    if (InheritanceComposite.this.discriminatorValueCombo.getText() == null || !InheritanceComposite.this.discriminatorValueCombo.getText().equals(discriminatorValue)) {
                        if (discriminatorValue == null) {
                            InheritanceComposite.this.discriminatorValueCombo.select(0);
                        } else {
                            InheritanceComposite.this.discriminatorValueCombo.setText(discriminatorValue);
                        }
                    }
                }
            });
        } else if (notification.getFeatureID(IEntity.class) == 10) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (InheritanceComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    InheritanceComposite.this.populateDiscriminatorValueCombo();
                }
            });
        }
    }

    protected void discriminatorColumnChanged(Notification notification) {
        if (notification.getFeatureID(INamedColumn.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (InheritanceComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    InheritanceComposite.this.populateColumnName();
                }
            });
        } else if (notification.getFeatureID(INamedColumn.class) == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (InheritanceComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    InheritanceComposite.this.populateDefaultColumnName();
                }
            });
        } else if (notification.getFeatureID(IDiscriminatorColumn.class) == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DiscriminatorType discriminatorType = InheritanceComposite.this.discriminatorColumn.getDiscriminatorType();
                    if (((StructuredSelection)InheritanceComposite.this.discriminatorTypeViewer.getSelection()).getFirstElement() != discriminatorType) {
                        InheritanceComposite.this.discriminatorTypeViewer.setSelection((ISelection)new StructuredSelection((Object)discriminatorType));
                    }
                }
            });
        }
    }

    public void dispose() {
        this.pkJoinColumnsComposite.dispose();
        super.dispose();
    }
}

