/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.List;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.InverseJoinColumnDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TableCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class JoinTableComposite
extends BaseJpaComposite {
    private IJoinTable joinTable;
    private final Adapter joinTableListener = this.buildJoinTableListener();
    protected TableCombo tableCombo;
    private ConnectionProfile connectionProfile;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private Button overrideDefaultJoinColumnsCheckBox;
    private JoinColumnsComposite joinColumnsComposite;
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private JoinColumnsComposite inverseJoinColumnsComposite;

    public JoinTableComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildJoinTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                JoinTableComposite.this.joinTableChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
            }

            public void closed(ConnectionProfile profile) {
                JoinTableComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).JoinTableComposite.this.tableCombo.populate();
                    }
                });
            }

            public void modified(ConnectionProfile profile) {
                JoinTableComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).JoinTableComposite.this.tableCombo.populate();
                    }
                });
            }

            public boolean okToClose(ConnectionProfile profile) {
                return true;
            }

            public void opened(ConnectionProfile profile) {
                JoinTableComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).JoinTableComposite.this.tableCombo.populate();
                    }
                });
            }

            public void databaseChanged(ConnectionProfile profile, final Database database) {
                JoinTableComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (database == (this).JoinTableComposite.this.tableCombo.getDatabase() && !JoinTableComposite.this.getControl().isDisposed()) {
                            (this).JoinTableComposite.this.tableCombo.populate();
                        }
                    }
                });
            }

            public void schemaChanged(ConnectionProfile profile, final Schema schema) {
                JoinTableComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (schema == (this).JoinTableComposite.this.tableCombo.getTableSchema() && !JoinTableComposite.this.getControl().isDisposed()) {
                            (this).JoinTableComposite.this.tableCombo.populate();
                        }
                    }
                });
            }

            public void tableChanged(ConnectionProfile profile, Table table) {
            }
        };
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            IJpaProject jpaProject = this.joinTable.getJpaProject();
            this.connectionProfile = jpaProject.connectionProfile();
        }
        return this.connectionProfile;
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.JoinTableComposite_name);
        this.tableCombo = new TableCombo(composite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableCombo.getCombo(), "org.eclipse.jpt.ui.mapping_joinTableName");
        this.overrideDefaultJoinColumnsCheckBox = this.getWidgetFactory().createButton(composite, JptUiMappingsMessages.JoinTableComposite_overrideDefaultJoinColumns, 32);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (JoinTableComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection()) {
                    IJoinColumn defaultJoinColumn = (IJoinColumn)JoinTableComposite.this.joinTable.getDefaultJoinColumns().get(0);
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    IJoinColumn joinColumn = JoinTableComposite.this.joinTable.createJoinColumn(0);
                    JoinTableComposite.this.joinTable.getSpecifiedJoinColumns().add((Object)joinColumn);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                } else {
                    JoinTableComposite.this.joinTable.getSpecifiedJoinColumns().clear();
                }
            }
        });
        this.joinColumnsComposite = new JoinColumnsComposite(composite, this.commandStack, this.getWidgetFactory(), JptUiMappingsMessages.JoinTableComposite_joinColumn);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.joinColumnsComposite.getControl().setLayoutData((Object)gridData);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.getWidgetFactory().createButton(composite, JptUiMappingsMessages.JoinTableComposite_overrideDefaultInverseJoinColumns, 32);
        this.overrideDefaultInverseJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (JoinTableComposite.this.overrideDefaultInverseJoinColumnsCheckBox.getSelection()) {
                    IJoinColumn defaultJoinColumn = (IJoinColumn)JoinTableComposite.this.joinTable.getDefaultInverseJoinColumns().get(0);
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    IJoinColumn joinColumn = JoinTableComposite.this.joinTable.createInverseJoinColumn(0);
                    JoinTableComposite.this.joinTable.getSpecifiedInverseJoinColumns().add((Object)joinColumn);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                } else {
                    JoinTableComposite.this.joinTable.getSpecifiedInverseJoinColumns().clear();
                }
            }
        });
        this.inverseJoinColumnsComposite = new JoinColumnsComposite(composite, this.commandStack, this.getWidgetFactory(), JptUiMappingsMessages.JoinTableComposite_inverseJoinColumn);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.inverseJoinColumnsComposite.getControl().setLayoutData((Object)gridData);
    }

    void addJoinColumn() {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getControl().getShell(), this.joinTable);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(JoinColumnInJoinTableDialog dialog) {
        if (dialog.open() != 0) {
            return;
        }
        int index = this.joinTable.getJoinColumns().size();
        IJoinColumn joinColumn = this.joinTable.createJoinColumn(index);
        this.joinTable.getSpecifiedJoinColumns().add((Object)joinColumn);
        joinColumn.setSpecifiedName(dialog.getSelectedName());
        joinColumn.setSpecifiedReferencedColumnName(dialog.getReferencedColumnName());
    }

    void addInverseJoinColumn() {
        InverseJoinColumnDialog dialog = new InverseJoinColumnDialog(this.getControl().getShell(), this.joinTable);
        this.addInverseJoinColumnFromDialog(dialog);
    }

    private void addInverseJoinColumnFromDialog(InverseJoinColumnDialog dialog) {
        if (dialog.open() != 0) {
            return;
        }
        int index = this.joinTable.getInverseJoinColumns().size();
        IJoinColumn joinColumn = this.joinTable.createInverseJoinColumn(index);
        this.joinTable.getSpecifiedInverseJoinColumns().add((Object)joinColumn);
        joinColumn.setSpecifiedName(dialog.getSelectedName());
        joinColumn.setSpecifiedReferencedColumnName(dialog.getReferencedColumnName());
    }

    void editJoinColumn(IJoinColumn joinColumn) {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(JoinColumnInJoinTableDialog dialog, IJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(JoinColumnInJoinTableDialog dialog, IJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                joinColumn.setSpecifiedName(null);
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            joinColumn.setSpecifiedName(name);
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                joinColumn.setSpecifiedReferencedColumnName(null);
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    void editInverseJoinColumn(IJoinColumn joinColumn) {
        InverseJoinColumnDialog dialog = new InverseJoinColumnDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    protected void joinTableChanged(Notification notification) {
        if (notification.getFeatureID(IJoinTable.class) == 11) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (JoinTableComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    JoinTableComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(JoinTableComposite.this.joinTable.containsSpecifiedJoinColumns());
                }
            });
        } else if (notification.getFeatureID(IJoinTable.class) == 14) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (JoinTableComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    JoinTableComposite.this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(JoinTableComposite.this.joinTable.containsSpecifiedInverseJoinColumns());
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.joinTable != null) {
            this.joinTable.eAdapters().add((Object)this.joinTableListener);
            this.addConnectionListener();
        }
    }

    protected void disengageListeners() {
        if (this.joinTable != null) {
            this.joinTable.eAdapters().remove((Object)this.joinTableListener);
            this.removeConnectionListener();
        }
    }

    public void doPopulate(EObject obj) {
        this.joinTable = (IJoinTable)obj;
        if (this.joinTable == null) {
            this.joinColumnsComposite.populate(null);
            this.inverseJoinColumnsComposite.populate(null);
            this.connectionProfile = null;
            return;
        }
        this.tableCombo.populate((EObject)this.joinTable);
        this.joinColumnsComposite.populate((EObject)new JoinColumnsOwner(this.joinTable));
        this.inverseJoinColumnsComposite.populate((EObject)new InverseJoinColumnsOwner(this.joinTable));
        this.overrideDefaultJoinColumnsCheckBox.setSelection(this.joinTable.containsSpecifiedJoinColumns());
        this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(this.joinTable.containsSpecifiedInverseJoinColumns());
    }

    protected void doPopulate() {
        this.tableCombo.populate();
        this.joinColumnsComposite.populate();
        this.inverseJoinColumnsComposite.populate();
    }

    public void dispose() {
        this.tableCombo.dispose();
        this.joinColumnsComposite.dispose();
        this.inverseJoinColumnsComposite.dispose();
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnsOwner
    extends JpaEObject
    implements JoinColumnsComposite.Owner {
        private IJoinTable joinTable;

        public InverseJoinColumnsOwner(IJoinTable joinTable) {
            this.joinTable = joinTable;
        }

        @Override
        public void addJoinColumn() {
            JoinTableComposite.this.addInverseJoinColumn();
        }

        @Override
        public boolean containsSpecifiedJoinColumns() {
            return this.joinTable.containsSpecifiedInverseJoinColumns();
        }

        @Override
        public IJoinColumn createJoinColumn(int index) {
            return this.joinTable.createJoinColumn(index);
        }

        @Override
        public List<IJoinColumn> getJoinColumns() {
            return this.joinTable.getInverseJoinColumns();
        }

        @Override
        public List<IJoinColumn> getSpecifiedJoinColumns() {
            return this.joinTable.getSpecifiedInverseJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsFeatureId() {
            return 14;
        }

        @Override
        public Class owningFeatureClass() {
            return IJoinTable.class;
        }

        @Override
        public void editJoinColumn(IJoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public EObject getEObject() {
            return this.joinTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsOwner
    extends JpaEObject
    implements JoinColumnsComposite.Owner {
        private IJoinTable joinTable;

        public JoinColumnsOwner(IJoinTable joinTable) {
            this.joinTable = joinTable;
        }

        @Override
        public void addJoinColumn() {
            JoinTableComposite.this.addJoinColumn();
        }

        @Override
        public boolean containsSpecifiedJoinColumns() {
            return this.joinTable.containsSpecifiedJoinColumns();
        }

        @Override
        public IJoinColumn createJoinColumn(int index) {
            return this.joinTable.createJoinColumn(index);
        }

        @Override
        public List<IJoinColumn> getJoinColumns() {
            return this.joinTable.getJoinColumns();
        }

        @Override
        public List<IJoinColumn> getSpecifiedJoinColumns() {
            return this.joinTable.getSpecifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsFeatureId() {
            return 11;
        }

        @Override
        public Class owningFeatureClass() {
            return IJoinTable.class;
        }

        @Override
        public void editJoinColumn(IJoinColumn joinColumn) {
            JoinTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public EObject getEObject() {
            return this.joinTable;
        }
    }
}

