/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.ui.internal.selection.ISelectionManager;
import org.eclipse.jpt.ui.internal.selection.ISelectionParticipant;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.selection.SelectionEvent;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class SelectionManager
implements ISelectionManager {
    private Set<IWorkbenchPage> pages = Collections.synchronizedSet(new HashSet());
    private Map<IWorkbenchPart, ISelectionParticipant> selectionParticipants = Collections.synchronizedMap(new HashMap());
    private IPageListener pageListener = new PageListener();
    private IPartListener2 partListener = new PartListener();
    private IWorkbenchWindow window;
    private Selection currentSelection = Selection.NULL_SELECTION;

    public void init(IWorkbenchWindow aWindow) {
        this.window = aWindow;
        aWindow.addPageListener(this.pageListener);
        this.initPage(aWindow.getActivePage());
    }

    void initPage(IWorkbenchPage page) {
        if (page != null && !this.pages.contains(page)) {
            page.addPartListener(this.partListener);
            this.pages.add(page);
            IEditorPart activeEditor = page.getActiveEditor();
            this.initPart((IWorkbenchPart)activeEditor);
            this.selectPart((IWorkbenchPart)activeEditor);
        }
    }

    void disposePage(IWorkbenchPage page) {
        if (page != null && this.pages.contains(page)) {
            page.removePartListener(this.partListener);
            this.pages.remove(page);
        }
    }

    void initPart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant;
        if (part != null && this.selectionParticipants.get(part) == null && (selectionParticipant = (ISelectionParticipant)part.getAdapter(ISelectionParticipant.class)) != null) {
            this.selectionParticipants.put(part, selectionParticipant);
        }
    }

    void selectPart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.select(selectionParticipant.getSelection());
        }
    }

    void hidePart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null && selectionParticipant.disposeOnHide()) {
            this.closePart(part);
        }
    }

    void closePart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.disposePart(part);
            this.checkForNoEditors();
        }
    }

    void disposePart(IWorkbenchPart part) {
        if (part != null && this.selectionParticipants.containsKey(part)) {
            this.selectionParticipants.remove(part).dispose();
        }
    }

    void checkForNoEditors() {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null || activePage.getActiveEditor() == null) {
            this.select(Selection.NULL_SELECTION);
        }
    }

    public void register(IWorkbenchPart part) {
        this.initPart(part);
    }

    public void select(Selection newSelection) {
        if (this.currentSelection.equals(newSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        this.fireSelectionChange(new SelectionEvent(newSelection, SelectionEvent.SELECTION, this));
    }

    public void deselect(Selection oldSelection) {
        if (this.currentSelection.equals(oldSelection)) {
            this.currentSelection = Selection.NULL_SELECTION;
            this.fireSelectionChange(new SelectionEvent(oldSelection, SelectionEvent.DESELECTION, this));
        }
    }

    private void fireSelectionChange(SelectionEvent event) {
        for (ISelectionParticipant sp : this.selectionParticipants.values()) {
            sp.selectionChanged(event);
        }
    }

    private ISelectionParticipant getSelectionParticipant(IWorkbenchPart part) {
        return this.selectionParticipants.get(part);
    }

    public Selection getCurrentSelection() {
        return this.currentSelection;
    }

    public void dispose() {
        this.window.removePageListener(this.pageListener);
        this.selectionParticipants.clear();
        CloneIterator stream = new CloneIterator(this.pages);
        while (stream.hasNext()) {
            this.disposePage((IWorkbenchPage)stream.next());
        }
        stream = new CloneIterator((Collection)this.selectionParticipants.keySet());
        while (stream.hasNext()) {
            this.disposePart((IWorkbenchPart)stream.next());
        }
    }

    private class PageListener
    implements IPageListener {
        public void pageActivated(IWorkbenchPage page) {
        }

        PageListener() {
        }

        public void pageClosed(IWorkbenchPage page) {
            SelectionManager.this.disposePage(page);
        }

        public void pageOpened(IWorkbenchPage page) {
            SelectionManager.this.initPage(page);
        }
    }

    private class PartListener
    implements IPartListener2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
                SelectionManager.this.selectPart(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.closePart(part);
                SelectionManager.this.disposePart(part);
                SelectionManager.this.checkForNoEditors();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.hidePart(part);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
            }
        }
    }
}

