/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.ui.internal.wizards.GenerateEntitiesWizard;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateEntitiesWizardPage
extends NewTypeWizardPage {
    CheckboxTableViewer tableTable;
    private boolean convertToCamelCase = true;
    private boolean fieldAccessType = true;
    private String collectionTypeName = Set.class.getName();
    private int fieldVisibility = 0;
    private int methodVisibility = 3;
    private boolean generateGettersAndSetters = true;
    private boolean generateDefaultConstructor = true;
    private boolean serializable = true;
    private boolean generateSerialVersionUID = true;
    private boolean generateEmbeddedIdForCompoundPK = true;
    private boolean synchronizePersistenceXml = false;
    private Map<Table, String> overrideEntityNames;
    static final String[] TABLE_TABLE_COLUMN_PROPERTIES = new String[]{"table", "entityName"};
    private static final int TABLE_COLUMN_INDEX = 0;
    private static final int ENTITY_NAME_COLUMN_INDEX = 1;

    GenerateEntitiesWizardPage() {
        super(true, "Generate Entities");
        this.setTitle(JptUiMessages.GenerateEntitiesWizardPage_generateEntities);
        this.setMessage(JptUiMessages.GenerateEntitiesWizardPage_chooseEntityTable);
    }

    void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_generateEntities");
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        final Button synchronizeClassesCheckBox = new Button(composite, 32);
        synchronizeClassesCheckBox.setText(JptUiMessages.GenerateEntitiesWizardPage_synchronizeClasses);
        synchronizeClassesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.setSynchronizePersistenceXml(synchronizeClassesCheckBox.getSelection());
            }
        });
        Group tablesGroup = new Group(composite, 16);
        tablesGroup.setLayout((Layout)new GridLayout(2, false));
        tablesGroup.setText(JptUiMessages.GenerateEntitiesWizardPage_tables);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tablesGroup.setLayoutData((Object)data);
        this.createTablesSelectionControl((Composite)tablesGroup);
        this.createButtonComposite(tablesGroup);
        GenerateEntitiesWizard generateEntitiesWizard = (GenerateEntitiesWizard)this.getWizard();
        Collection<Table> possibleTables = generateEntitiesWizard.getPossibleTables();
        this.initTablesSelectionControl(possibleTables);
        synchronizeClassesCheckBox.setSelection(!generateEntitiesWizard.getJpaProject().isDiscoverAnnotatedClasses());
        this.setSynchronizePersistenceXml(synchronizeClassesCheckBox.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableTable.getControl(), "org.eclipse.jpt.ui.dialog_generateEntities_tables");
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private void selectAllTables() {
        this.tableTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    private void deselectAllTables() {
        this.tableTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void initTablesSelectionControl(Collection<Table> possibleTables) {
        this.overrideEntityNames = new HashMap<Table, String>(possibleTables.size());
        this.tableTable.setInput(possibleTables);
    }

    private void createTablesSelectionControl(Composite parent) {
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        org.eclipse.swt.widgets.Table table = new org.eclipse.swt.widgets.Table((Composite)layout, 68388);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptUiMessages.GenerateEntitiesWizardPage_tableColumn);
        tableNameColumn.setResizable(true);
        TableColumn entityNameColumn = new TableColumn(table, 0, 1);
        entityNameColumn.setText(JptUiMessages.GenerateEntitiesWizardPage_entityNameColumn);
        entityNameColumn.setResizable(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 20);
        gd.widthHint = 600;
        layout.setLayoutData(gd);
        this.tableTable = new CheckboxTableViewer(table);
        this.tableTable.setUseHashlookup(true);
        this.tableTable.setLabelProvider(this.buildTableTableLabelProvider());
        this.tableTable.setContentProvider(this.buildTableTableContentProvider());
        this.tableTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((Table)e1).getName().compareTo(((Table)e2).getName());
            }
        });
        this.tableTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenerateEntitiesWizardPage.this.handleTablesListSelectionChanged(event);
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    GenerateEntitiesWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private void createButtonComposite(Group tablesGroup) {
        Composite buttonComposite = new Composite((Composite)tablesGroup, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(JptUiMessages.General_selectAll);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.selectAllTables();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(JptUiMessages.General_deselectAll);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        deselectAllButton.setLayoutData((Object)gridData);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.deselectAllTables();
            }
        });
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
        this.tableTable.editElement(selected[0], 1);
    }

    private void addCellEditors() {
        this.tableTable.setColumnProperties(TABLE_TABLE_COLUMN_PROPERTIES);
        TextCellEditor[] editors = new TextCellEditor[TABLE_TABLE_COLUMN_PROPERTIES.length];
        editors[1] = new TextCellEditor((Composite)this.tableTable.getTable(), 4);
        this.tableTable.setCellEditors((CellEditor[])editors);
        this.tableTable.setCellModifier(this.buildTableTableCellModifier());
    }

    void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.setPageComplete(true);
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    private ICellModifier buildTableTableCellModifier() {
        return new TableTableCellModifier();
    }

    Collection<Table> getSelectedTables() {
        ArrayList<Table> selectedTables = new ArrayList<Table>();
        Object[] objectArray = this.tableTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTable = objectArray[n2];
            selectedTables.add((Table)selectedTable);
            ++n2;
        }
        return selectedTables;
    }

    private boolean hasTablesSelected() {
        return this.tableTable != null ? this.getSelectedTables().size() > 0 : false;
    }

    void updateTablesListViewer(Collection<Table> possibleTables) {
        if (this.tableTable != null) {
            this.initTablesSelectionControl(possibleTables);
        }
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (this.isPageComplete() && !this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }

    String entityName(Table table) {
        String overrideEntityName = this.overrideEntityNames.get(table);
        return overrideEntityName != null ? overrideEntityName : this.defaultEntityName(table);
    }

    private String defaultEntityName(Table table) {
        String entityName = table.shortJavaClassName();
        if (this.convertToCamelCase) {
            entityName = StringTools.convertUnderscoresToCamelCase((String)entityName);
        }
        return entityName;
    }

    void setOverrideEntityName(Table table, String name) {
        if (table.shortJavaClassName().equals(name)) {
            this.overrideEntityNames.remove(table);
        } else {
            this.overrideEntityNames.put(table, name);
        }
    }

    boolean convertToCamelCase() {
        return this.convertToCamelCase;
    }

    boolean fieldAccessType() {
        return this.fieldAccessType;
    }

    String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    int getFieldVisibility() {
        return this.fieldVisibility;
    }

    int getMethodVisibility() {
        return this.methodVisibility;
    }

    boolean generateGettersAndSetters() {
        return this.generateGettersAndSetters;
    }

    boolean generateDefaultConstructor() {
        return this.generateDefaultConstructor;
    }

    boolean serializable() {
        return this.serializable;
    }

    boolean generateSerialVersionUID() {
        return this.generateSerialVersionUID;
    }

    boolean generateEmbeddedIdForCompoundPK() {
        return this.generateEmbeddedIdForCompoundPK;
    }

    boolean synchronizePersistenceXml() {
        return this.synchronizePersistenceXml;
    }

    private void setSynchronizePersistenceXml(boolean synchronizePersistenceXml) {
        this.synchronizePersistenceXml = synchronizePersistenceXml;
    }

    Map<Table, String> getOverrideEntityNames() {
        return this.overrideEntityNames;
    }

    private class TableTableCellModifier
    implements ICellModifier {
        TableTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1]);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                return GenerateEntitiesWizardPage.this.entityName((Table)element);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            if (!(element instanceof Table)) {
                return;
            }
            boolean unchanged = false;
            Table table = (Table)element;
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                unchanged = GenerateEntitiesWizardPage.this.entityName(table).equals(value);
                GenerateEntitiesWizardPage.this.setOverrideEntityName(table, (String)value);
            }
            if (!unchanged) {
                GenerateEntitiesWizardPage.this.tableTable.update((Object)table, new String[]{property});
            }
        }
    }

    private class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((Table)element).getName();
                }
                case 1: {
                    return GenerateEntitiesWizardPage.this.entityName((Table)element);
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

