/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.JptUiPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetInstallPage;

public class JpaFacetWizardPage
extends DataModelFacetInstallPage
implements IJpaFacetDataModelProperties {
    public JpaFacetWizardPage() {
        super("jpt.jpa.facet.install.page");
        this.setTitle(JptUiMessages.JpaFacetWizardPage_title);
        this.setDescription(JptUiMessages.JpaFacetWizardPage_description);
        this.setImageDescriptor(JptUiPlugin.getPlugin().getImageDescriptor("full/wizban/jpa_facet_wizban"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        new PlatformGroup(composite);
        new ConnectionGroup(composite);
        new ClasspathConfigGroup(composite);
        new PersistentClassManagementGroup(composite);
        new OrmXmlGroup(composite);
        this.setUpRuntimeListener();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jpt.ui.dialog_JPAFacet");
        return composite;
    }

    private void setUpRuntimeListener() {
        final ChangeTargetedRuntimesDataModel runtimeDataModel = this.getRuntimeDataModel();
        this.model.setProperty("IJpaFacetDataModelProperties.RUNTIME", (Object)runtimeDataModel.getPrimaryRuntime());
        runtimeDataModel.addListener("primaryRuntimeChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.RUNTIME", (Object)runtimeDataModel.getPrimaryRuntime());
            }
        });
    }

    private ChangeTargetedRuntimesDataModel getRuntimeDataModel() {
        FacetsSelectionPage facetPage = null;
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof FacetsSelectionPage) {
                facetPage = (FacetsSelectionPage)page;
                break;
            }
            ++n2;
        }
        return facetPage == null ? null : facetPage.panel.getDataModel().getTargetedRuntimesDataModel();
    }

    private Button createButton(Composite container, int span, String text, int style) {
        Button button = new Button(container, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Combo createCombo(Composite container, int span, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaFacetDataModelProperties.PLATFORM_ID", "IJpaFacetDataModelProperties.CONNECTION", "IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", "IJpaFacetDataModelProperties.JPA_LIBRARY", "IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"};
    }

    public boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        return this.model.validate().getSeverity() != 4;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage();
        }
    }

    private final class ClasspathConfigGroup {
        private final Button useServerLibButton;
        private final Button specifyLibButton;
        private final Combo jpaLibCombo;
        private final Link jpaPrefsLink;
        private final Link userLibsLink;

        public ClasspathConfigGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_jpaImplementationLabel);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            boolean useServerLib = ((DataModelWizardPage)JpaFacetWizardPage.this).model.getBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
            this.useServerLibButton = JpaFacetWizardPage.this.createButton((Composite)group, 2, JptUiMessages.JpaFacetWizardPage_userServerLibLabel, 16);
            this.useServerLibButton.setSelection(useServerLib);
            this.useServerLibButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", true);
                }
            });
            this.specifyLibButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_specifyLibLabel, 16);
            this.specifyLibButton.setSelection(!useServerLib);
            this.specifyLibButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", false);
                }
            });
            this.jpaLibCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.jpaLibCombo, "IJpaFacetDataModelProperties.JPA_LIBRARY", null);
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.addListener(new IDataModelListener(){

                public void propertyChanged(DataModelEvent event) {
                    if ("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION".equals(event.getPropertyName())) {
                        boolean useServerLib = (Boolean)event.getProperty();
                        ClasspathConfigGroup.this.useServerLibButton.setSelection(useServerLib);
                        ClasspathConfigGroup.this.specifyLibButton.setSelection(!useServerLib);
                        ClasspathConfigGroup.this.jpaLibCombo.setEnabled(!useServerLib);
                    }
                }
            });
            this.jpaPrefsLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.jpaPrefsLink.setLayoutData((Object)data);
            this.jpaPrefsLink.setText(JptUiMessages.JpaFacetWizardPage_jpaPrefsLink);
            this.jpaPrefsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClasspathConfigGroup.this.promptToConfigJpaPrefs();
                }
            });
            this.userLibsLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.userLibsLink.setLayoutData((Object)data);
            this.userLibsLink.setText(JptUiMessages.JpaFacetWizardPage_userLibsLink);
            this.userLibsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClasspathConfigGroup.this.promptToConfigUserLibraries();
                }
            });
        }

        private void promptToConfigJpaPrefs() {
            PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)JpaFacetWizardPage.this.getShell(), (String)"org.eclipse.jpt.ui.jpaPreferencePage", (String[])new String[]{"org.eclipse.jpt.ui.jpaPreferencePage"}, null);
            dlg.open();
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("IJpaFacetDataModelProperties.JPA_LIBRARY", 4);
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("IJpaFacetDataModelProperties.JPA_LIBRARY", 2);
        }

        private void promptToConfigUserLibraries() {
            PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)JpaFacetWizardPage.this.getShell(), (String)"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage", (String[])new String[]{"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage"}, null);
            dlg.open();
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("IJpaFacetDataModelProperties.JPA_LIBRARY", 4);
        }
    }

    private final class ConnectionGroup {
        private final Combo connectionCombo;
        private Link connectionLink;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_database");
            this.connectionCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            this.connectionCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)ConnectionGroup.this.connectionCombo.getItem(ConnectionGroup.this.connectionCombo.getSelectionIndex()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fillConnections();
            if (this.connectionCombo.getItemCount() > 0) {
                this.connectionCombo.select(0);
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)this.connectionCombo.getItem(0));
            } else {
                this.connectionCombo.clearSelection();
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.CONNECTION", null);
            }
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
        }

        private void fillConnections() {
            this.connectionCombo.removeAll();
            Iterator stream = ConnectionProfileRepository.instance().profileNames();
            while (stream.hasNext()) {
                this.connectionCombo.add((String)stream.next());
            }
        }

        private void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewProfile();
            if (connectionName != null) {
                this.fillConnections();
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
                this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
            }
        }
    }

    private final class OrmXmlGroup {
        private final Button createOrmXmlButton;

        public OrmXmlGroup(Composite composite) {
            Composite group = new Composite(composite, 0);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_createORM");
            this.createOrmXmlButton = new Button(group, 32);
            this.createOrmXmlButton.setText(JptUiMessages.JpaFacetWizardPage_createOrmXmlButton);
            this.createOrmXmlButton.setSelection(((DataModelWizardPage)JpaFacetWizardPage.this).model.getBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML"));
            this.createOrmXmlButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML", OrmXmlGroup.this.createOrmXmlButton.getSelection());
                }
            });
        }
    }

    private final class PersistentClassManagementGroup {
        private final Button discoverClassesButton;
        private final Button listClassesButton;

        public PersistentClassManagementGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            boolean discoverClasses = ((DataModelWizardPage)JpaFacetWizardPage.this).model.getBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
            this.discoverClassesButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton, 16);
            this.discoverClassesButton.setSelection(discoverClasses);
            this.discoverClassesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", true);
                }
            });
            this.listClassesButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton, 16);
            this.listClassesButton.setSelection(!discoverClasses);
            this.listClassesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", false);
                }
            });
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.addListener(new IDataModelListener(){

                public void propertyChanged(DataModelEvent event) {
                    if ("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES".equals(event.getPropertyName())) {
                        boolean discoverClasses = (Boolean)event.getProperty();
                        PersistentClassManagementGroup.this.discoverClassesButton.setSelection(discoverClasses);
                        PersistentClassManagementGroup.this.listClassesButton.setSelection(!discoverClasses);
                    }
                }
            });
        }
    }

    private final class PlatformGroup {
        private final ComboViewer platformCombo;

        public PlatformGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_JPAPlatform");
            this.platformCombo = new ComboViewer(JpaFacetWizardPage.this.createCombo((Composite)group, 1, true));
            this.platformCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return CollectionTools.array((Iterator)JpaPlatformRegistry.instance().allJpaPlatformIds());
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.platformCombo.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return JpaPlatformRegistry.instance().jpaPlatformLabel((String)element);
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }
            });
            this.platformCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("IJpaFacetDataModelProperties.PLATFORM_ID", ((StructuredSelection)event.getSelection()).getFirstElement());
                }
            });
            this.platformCombo.setInput((Object)"null input");
            if (this.platformCombo.getElementAt(0) != null) {
                this.platformCombo.setSelection((ISelection)new StructuredSelection(this.platformCombo.getElementAt(0)));
            }
        }
    }
}

