/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.ChangeUtil;
import com.ibm.etools.emf.event.impl.ChangeHelper;
import com.ibm.etools.emf.event.impl.EventHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ChangeUtilImpl
implements ChangeUtil {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public List getAddedObjects(Change[] changes) {
        BasicEList addedObjects = new BasicEList();
        int c = 0;
        while (c < changes.length) {
            Change change = changes[c];
            if (change.getOldEObject() == null) {
                addedObjects.add(change.getNewEObject());
            }
            ++c;
        }
        return addedObjects;
    }

    public List getRemovedObjects(Change[] changes) {
        BasicEList removedObjects = new BasicEList();
        int c = 0;
        while (c < changes.length) {
            Change change = changes[c];
            if (change.getNewEObject() == null) {
                removedObjects.add(change.getOldEObject());
            }
            ++c;
        }
        return removedObjects;
    }

    public String displaySummary(Change[] changes) {
        Change change;
        String summary = "";
        int maxOldURI = 6;
        int maxNewURI = 6;
        int i = 0;
        while (i < changes.length) {
            change = changes[i];
            String oldURI = ChangeUtilImpl.getURIString(change.getOldEObject());
            String newURI = ChangeUtilImpl.getURIString(change.getNewEObject());
            if (oldURI != null && oldURI.length() > maxOldURI) {
                maxOldURI = oldURI.length();
            }
            if (newURI != null && newURI.length() > maxNewURI) {
                maxNewURI = newURI.length();
            }
            ++i;
        }
        if (changes.length > 0) {
            summary = String.valueOf(summary) + "\t" + ChangeUtilImpl.padding("oldURI", maxOldURI + 1) + ChangeUtilImpl.padding("newURI", maxNewURI + 1) + "\n";
            summary = String.valueOf(summary) + "\t" + ChangeUtilImpl.padding("------", maxOldURI + 1) + ChangeUtilImpl.padding("------", maxNewURI + 1) + "\n";
        }
        i = 0;
        while (i < changes.length) {
            change = changes[i];
            summary = String.valueOf(summary) + "\t" + ChangeUtilImpl.padding(ChangeUtilImpl.getURIString(change.getOldEObject()), maxOldURI + 1) + ChangeUtilImpl.padding(ChangeUtilImpl.getURIString(change.getNewEObject()), maxNewURI + 1) + "\n";
            ++i;
        }
        return summary;
    }

    private static String padding(String in, int totalLength) {
        String out = in == null ? "<null>" : in;
        int i = out.length();
        while (i < totalLength) {
            out = String.valueOf(out) + " ";
            ++i;
        }
        return out;
    }

    public String displayDetails(Change[] changes) {
        String details = "";
        int c = 0;
        while (c < changes.length) {
            Change change = changes[c];
            EObject oldObject = change.getOldEObject();
            EObject newObject = change.getNewEObject();
            String oldURI = ChangeUtilImpl.getURIString(oldObject);
            String newURI = ChangeUtilImpl.getURIString(newObject);
            details = String.valueOf(details) + oldURI + "=>" + newURI + "\n";
            details = String.valueOf(details) + "\told: " + EventHelper.objectToString(oldObject) + "\n\tnew: " + EventHelper.objectToString(newObject) + "\n";
            Change.Setting[] changedSettings = change.getSettings();
            int i = 0;
            while (i < changedSettings.length) {
                List removedValues;
                Change.Setting changedSetting = changedSettings[i];
                details = String.valueOf(details) + "\t\t" + changedSetting.toString() + "\n";
                List addedValues = changedSetting.getAddedValues();
                if (addedValues != null && addedValues.size() > 0) {
                    details = String.valueOf(details) + "\t\t\tAddedValues=" + EventHelper.objectToString(addedValues) + "\n";
                }
                if ((removedValues = changedSetting.getRemovedValues()) != null && removedValues.size() > 0) {
                    details = String.valueOf(details) + "\t\t\tRemovedValues=" + EventHelper.objectToString(removedValues) + "\n";
                }
                ++i;
            }
            ++c;
        }
        return details;
    }

    protected static String getURIString(Object object) {
        EObject eObject;
        Resource r;
        if (object == null) {
            return null;
        }
        if (object instanceof EObject && (r = (eObject = (EObject)object).eResource()) != null) {
            String fragment = r.getURIFragment(eObject);
            String value = eObject.eResource().getURI().appendFragment(fragment).toString();
            return value;
        }
        return null;
    }

    public Change[] getChanges(Notifier oldTopObject, Notifier newTopObject, Map oldToNewMap) {
        ChangeHelper changeHelper = new ChangeHelper(oldToNewMap);
        return changeHelper.createChanges(oldTopObject, newTopObject);
    }

    public Map createInverseMap(Map forwardMap) {
        HashMap inverseMap = new HashMap();
        Set entrySet = forwardMap.entrySet();
        Iterator e = entrySet.iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }
}

