/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor;

import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.monitor.ConnectionListener;
import org.eclipse.wst.wsi.internal.core.monitor.Monitor;
import org.eclipse.wst.wsi.internal.core.monitor.SocketHandler;
import org.eclipse.wst.wsi.internal.core.monitor.config.Redirect;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class SocketConnection
extends Thread {
    protected Monitor monitor;
    protected Redirect redirect;
    protected Socket inSocket;
    protected Socket outSocket;
    protected String httpProxyHost = null;
    protected int httpProxyPort;
    protected SocketHandler requestSocketHandler = null;
    protected SocketHandler responseSocketHandler = null;
    private Vector listeners = new Vector();

    public SocketConnection(Monitor monitor, Redirect redirect, Socket inSocket) {
        this.monitor = monitor;
        this.redirect = redirect;
        this.inSocket = inSocket;
        this.start();
    }

    public void run() {
        this.loadHttpProxySettings();
        try {
            this.outSocket = new Socket(this.redirect.getToHost(), this.redirect.getToPort());
            this.inSocket.setSoTimeout(this.redirect.getReadTimeoutSeconds() * 1000);
            int conversationId = this.monitor.getNextConversationId();
            this.requestSocketHandler = new SocketHandler(this, "request", conversationId, this.redirect.getToHost(), this.inSocket, this.outSocket, this.redirect.getReadTimeoutSeconds());
            this.responseSocketHandler = new SocketHandler(this, "response", conversationId, this.redirect.getToHost(), this.outSocket, this.inSocket, this.redirect.getReadTimeoutSeconds());
            this.requestSocketHandler.setPairedSocketHandler(this.responseSocketHandler);
            this.responseSocketHandler.setPairedSocketHandler(this.requestSocketHandler);
        }
        catch (Exception exception) {
            Monitor.staticPrintMessage("error04", this.redirect.getToHost(), "Monitor cannot connect to a redirect host:");
            this.shutdown();
            try {
                this.inSocket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void logMessage(int conversationID, String connectionType, String timestamp, String senderHostAndPort, String receiverHostAndPort, StringBuffer messageBuffer, int bom, String encoding) throws WSIException {
        MessageEntry messageEntry = null;
        messageEntry = this.createMessageEntry(conversationID, connectionType, timestamp, senderHostAndPort, receiverHostAndPort, messageBuffer.toString(), bom, encoding);
        this.monitor.getMessageEntryQueue().addMessageEntry(messageEntry);
    }

    private MessageEntry createMessageEntry(int conversationID, String messageType, String timestamp, String senderHostAndPort, String receiverHostAndPort, String message, int bom, String encoding) throws WSIException {
        MessageEntry messageEntry = this.monitor.getLog().createLogEntry();
        messageEntry.setConversationId(String.valueOf(conversationID));
        messageEntry.setType(messageType);
        messageEntry.setTimestamp(timestamp);
        messageEntry.setSenderHostAndPort(senderHostAndPort);
        messageEntry.setReceiverHostAndPort(receiverHostAndPort);
        messageEntry.setEncoding(encoding);
        String httpHeaders = Utils.getHTTPHeaders(message);
        messageEntry.setHTTPHeaders(httpHeaders);
        if (Utils.isMultipartRelatedMessage(httpHeaders)) {
            MimeParts mimeParts = Utils.parseMultipartRelatedMessage(message, httpHeaders, encoding);
            if (mimeParts == null) {
                String content = Utils.getContent(message);
                messageEntry.setMessage(content);
                messageEntry.setMimeContent(false);
            } else {
                messageEntry.setMimeParts(mimeParts);
                messageEntry.setMimeContent(true);
            }
        } else {
            String content = Utils.getContent(message);
            messageEntry.setMessage(content);
            messageEntry.setMimeContent(false);
        }
        if (bom != 0) {
            messageEntry.setBOM(bom);
        }
        return messageEntry;
    }

    public void loadHttpProxySettings() {
        this.httpProxyHost = System.getProperty("http.proxyHost");
        if (this.httpProxyHost != null && this.httpProxyHost.equals("")) {
            this.httpProxyHost = null;
        }
        if (this.httpProxyHost != null) {
            String portString = System.getProperty("http.proxyPort");
            this.httpProxyPort = portString == null || portString.equals("") ? 80 : Integer.parseInt(portString);
        }
    }

    Monitor getMonitor() {
        return this.monitor;
    }

    synchronized void wakeUp() {
        this.fireConnectionClosed();
        this.notifyAll();
    }

    public void shutdown() {
        if (this.requestSocketHandler != null) {
            this.requestSocketHandler.shutdown();
        }
        if (this.responseSocketHandler != null) {
            this.responseSocketHandler.shutdown();
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireConnectionClosed() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConnectionListener listener = (ConnectionListener)i.next();
            listener.connectionClosed(this);
        }
    }
}

