/*******************************************************************************
* Copyright (c) 2006 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.expression.parser;

public interface ExpressionParsersym {
    public final static int
      TK_IDENT = 1,
      TK_STRING = 15,
      TK_INT_CONST = 16,
      TK_REAL_CONST = 17,
      TK_let = 25,
      TK_switch = 24,
      TK_implies = 30,
      TK_new = 18,
      TK_false = 19,
      TK_true = 20,
      TK_null = 21,
      TK_default = 31,
      TK_case = 32,
      TK_Collection = 3,
      TK_List = 4,
      TK_Set = 5,
      TK_typeSelect = 6,
      TK_collect = 7,
      TK_select = 8,
      TK_reject = 9,
      TK_exists = 10,
      TK_notExists = 11,
      TK_forAll = 12,
      TK_QUESTION_MARK = 33,
      TK_DCOLON = 26,
      TK_COLON = 27,
      TK_LPAREN = 2,
      TK_RPAREN = 22,
      TK_LCURLY = 13,
      TK_RCURLY = 28,
      TK_LSQUARE = 34,
      TK_RSQUARE = 35,
      TK_ARROW = 36,
      TK_NOT = 14,
      TK_AND = 37,
      TK_OR = 38,
      TK_ASSIGN = 39,
      TK_EQ = 40,
      TK_NE = 41,
      TK_GE = 42,
      TK_LE = 43,
      TK_GT = 44,
      TK_LT = 45,
      TK_PLUS = 46,
      TK_MINUS = 23,
      TK_MULTI = 47,
      TK_DIV = 48,
      TK_DOT = 29,
      TK_COMMA = 49,
      TK_BAR = 50,
      TK_EOF_TOKEN = 51,
      TK_ERROR_TOKEN = 52;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "IDENT",
                 "LPAREN",
                 "Collection",
                 "List",
                 "Set",
                 "typeSelect",
                 "collect",
                 "select",
                 "reject",
                 "exists",
                 "notExists",
                 "forAll",
                 "LCURLY",
                 "NOT",
                 "STRING",
                 "INT_CONST",
                 "REAL_CONST",
                 "new",
                 "false",
                 "true",
                 "null",
                 "RPAREN",
                 "MINUS",
                 "switch",
                 "let",
                 "DCOLON",
                 "COLON",
                 "RCURLY",
                 "DOT",
                 "implies",
                 "default",
                 "case",
                 "QUESTION_MARK",
                 "LSQUARE",
                 "RSQUARE",
                 "ARROW",
                 "AND",
                 "OR",
                 "ASSIGN",
                 "EQ",
                 "NE",
                 "GE",
                 "LE",
                 "GT",
                 "LT",
                 "PLUS",
                 "MULTI",
                 "DIV",
                 "COMMA",
                 "BAR",
                 "EOF_TOKEN",
                 "ERROR_TOKEN"
             };

    public final static boolean isValidForParser = true;
}
