/*******************************************************************************
 * Copyright (c) 2004, 2006 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;

import java.util.Vector;

import org.eclipse.draw2d.AbstractConnectionAnchor;

import org.eclipse.draw2d.IFigure;

import org.eclipse.draw2d.PolylineConnection;

import org.eclipse.draw2d.PositionConstants;

import org.eclipse.draw2d.geometry.Point;

import org.eclipse.draw2d.geometry.PrecisionPoint;

import org.eclipse.draw2d.geometry.Rectangle;

/**
 * 
 */

public class PortConnectionAnchor extends AbstractConnectionAnchor

{

	// CR386077: SplitActivity True and False outputs switch positions based on
	// their targets

	protected int orientation = PositionConstants.NONE;

	/**
	 * 
	 * 
	 * 
	 */

	public PortConnectionAnchor()

	{

		super();

		// TODO Auto-generated constructor stub

	}

	/**
	 * 
	 * @param owner
	 * 
	 */

	public PortConnectionAnchor(IFigure owner)

	{

		super(owner);

	}

	// CR386077: SplitActivity True and False outputs switch positions based on
	// their targets

	public int getOrientation()

	{

		return orientation;

	}

	public void setOrientation(int o)

	{

		orientation = o;

		((PortFigure) getOwner()).setOrientation(orientation);

	}

	/*
	 * 
	 * (non-Javadoc)
	 * 
	 * 
	 * 
	 * @see org.eclipse.draw2d.ConnectionAnchor#getLocation(org.eclipse.draw2d.geometry.Point)
	 * 
	 */

	public Point getLocation(Point arg0)

	{

		PortFigure portFigure = (PortFigure) getOwner();

		Point result = new Point(0, 0);

		Rectangle r = portFigure.getBounds();

		switch (portFigure.getOrientation())

		{

		case PositionConstants.NORTH:

			result = new PrecisionPoint(r.x + r.width / 2, r.y);

			break;

		case PositionConstants.SOUTH:

			result = new PrecisionPoint(r.x + r.width / 2, r.y + r.height);

			break;

		case PositionConstants.WEST:

			result = new PrecisionPoint(r.x, r.y + r.height / 2);

			break;

		case PositionConstants.EAST:

			result = new PrecisionPoint(r.x + r.width, r.y + r.height / 2);

			break;

		}

		portFigure.translateToAbsolute(result);

		return result;

	}

	public Vector getConnections()

	{

		Vector list = new Vector();

		Iterator it = listeners.iterator();

		while (it.hasNext())

		{

			Object listener = it.next();

			if (listener instanceof PolylineConnection)

				list.add(listener);

		}

		return list;

	}

}
