/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.pagedesigner;

import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMDocType;

/**
 * @author mengbo
 */
public class IHTMLConstants {
	public static final String TAG_A = "a"; // anchor

	public static final String TAG_ABBR = "abbr"; // abbreviated form (e.g.,

	// WWW, HTTP, etc.)

	public static final String TAG_ACRONYM = "acronym";

	public static final String TAG_ADDRESS = "address"; // information on author

	public static final String TAG_APPLET = "applet"; // Java applet

	public static final String TAG_AREA = "area"; // client-side image map

	// area

	public static final String TAG_B = "b"; // bold text style

	public static final String TAG_BASE = "base"; // document base URI

	public static final String TAG_BASEFONT = "basefont"; // base font size

	public static final String TAG_BDO = "bdo"; // I18N BiDi over-ride

	public static final String TAG_BIG = "big"; // large text style

	public static final String TAG_BLOCKQUOTE = "blockquote"; // long

	// quotation

	public static final String TAG_BODY = "body"; // document body

	public static final String TAG_BR = "br"; // forced line break

	public static final String TAG_BUTTON = "button"; // push button

	public static final String TAG_CAPTION = "caption"; // table caption

	public static final String TAG_CENTER = "center"; // shorthand for DIV

	// align=center

	public static final String TAG_CITE = "cite"; // citation

	public static final String TAG_CODE = "code"; // computer code fragment

	public static final String TAG_COL = "col"; // table column

	public static final String TAG_COLGROUP = "colgroup"; // table column

	// group

	public static final String TAG_DD = "dd"; // definition description

	public static final String TAG_DEL = "del"; // deleted text

	public static final String TAG_DFN = "dfn"; // instance definition

	public static final String TAG_DIR = "dir"; // directory list

	public static final String TAG_DIV = "div"; // generic language/style

	// container

	public static final String TAG_DL = "dl"; // definition list

	public static final String TAG_DT = "dt"; // definition term

	public static final String TAG_EM = "em"; // emphasis

	public static final String TAG_FIELDSET = "fieldset"; // form control

	// group

	public static final String TAG_FONT = "font"; // local change to font

	public static final String TAG_FORM = "form"; // interactive form

	public static final String TAG_FRAME = "frame"; // subwindow

	public static final String TAG_FRAMESET = "frameset"; // window

	// subdivision

	public static final String TAG_H1 = "h1"; // heading

	public static final String TAG_H2 = "h2"; // heading

	public static final String TAG_H3 = "h3"; // heading

	public static final String TAG_H4 = "h4"; // heading

	public static final String TAG_H5 = "h5"; // heading

	public static final String TAG_H6 = "h6"; // heading

	public static final String TAG_HEAD = "head"; // document head

	public static final String TAG_HR = "hr"; // horizontal rule

	public static final String TAG_HTML = "html"; // document root element

	public static final String TAG_I = "i"; // italic text style

	public static final String TAG_IFRAME = "iframe"; // inline subwindow

	public static final String TAG_IMG = "img"; // Embedded image

	public static final String TAG_INPUT = "input"; // form control

	public static final String TAG_INS = "ins"; // inserted text

	public static final String TAG_ISINDEX = "isindex"; // single line prompt

	public static final String TAG_KBD = "kbd"; // text to be entered by the

	// user

	public static final String TAG_LABEL = "label"; // form field label text

	public static final String TAG_LEGEND = "legend"; // fieldset legend

	public static final String TAG_LI = "li"; // list item

	public static final String TAG_LINK = "link"; // a media-independent link

	public static final String TAG_MAP = "map"; // client-side image map

	public static final String TAG_MENU = "menu"; // menu list

	public static final String TAG_META = "meta"; // generic metainformation

	public static final String TAG_NOEMBED = "noembed";

	public static final String TAG_NOFRAMES = "noframes"; // alternate content

	// container for non
	// frame-based
	// rendering

	public static final String TAG_NOSCRIPT = "noscript"; // alternate content

	// container for non
	// script-based
	// rendering

	public static final String TAG_OBJECT = "object"; // generic embedded

	// object

	public static final String TAG_OL = "ol"; // ordered list

	public static final String TAG_OPTGROUP = "optgroup"; // option group

	public static final String TAG_OPTION = "option"; // selectable choice

	public static final String TAG_P = "p"; // paragraph

	public static final String TAG_PARAM = "param"; // named property value

	public static final String TAG_PRE = "pre"; // preformatted text

	public static final String TAG_Q = "q"; // short inline quotation

	public static final String TAG_S = "s"; // strike-through text style

	public static final String TAG_SAMP = "samp"; // sample program output,

	// scripts, etc.

	public static final String TAG_SCRIPT = "script"; // script statements

	public static final String TAG_SELECT = "select"; // option selector

	public static final String TAG_SMALL = "small"; // small text style

	public static final String TAG_SPAN = "span"; // generic language/style

	// container

	public static final String TAG_STRIKE = "strike"; // strike-through text

	public static final String TAG_STRONG = "strong"; // strong emphasis

	public static final String TAG_STYLE = "style"; // style info

	public static final String TAG_SUB = "sub"; // subscript

	public static final String TAG_SUP = "sup"; // superscript

	public static final String TAG_TABLE = "table";

	public static final String TAG_TBODY = "tbody"; // table body

	public static final String TAG_TD = "td"; // table data cell

	public static final String TAG_TEXTAREA = "textarea"; // multi-line text

	// field

	public static final String TAG_TFOOT = "tfoot"; // table footer

	public static final String TAG_TH = "th"; // table header cell

	public static final String TAG_THEAD = "thead"; // table header

	public static final String TAG_TITLE = "title"; // document title

	public static final String TAG_TR = "tr"; // table row

	public static final String TAG_TT = "tt"; // teletype or monospaced text

	// style

	public static final String TAG_U = "u"; // underlined text style

	public static final String TAG_UL = "ul"; // unordered list

	public static final String TAG_VAR = "var"; // instance of a variable or

	/**
	 * Tag identifier for an HTML form tag
	 */
	public static final TagIdentifier TAG_IDENTIFIER_HTML_FORM =
	    TagIdentifierFactory.createJSPTagWrapper(CMDocType.HTML_DOC_TYPE, TAG_FORM);
	
    // program argument

	public static final String ATTR_ABBR = "abbr";

	public static final String ATTR_ACCEPTCHARSET = "accept-charset";

	public static final String ATTR_ACCEPT = "accept";

	public static final String ATTR_ACCESSKEY = "accesskey";

	public static final String ATTR_ACTION = "action";

	public static final String ATTR_ALIGN = "align";

	public static final String ATTR_ALINK = "alink";

	public static final String ATTR_ALT = "alt";

	public static final String ATTR_ARCHIVE = "archive";

	public static final String ATTR_AXIS = "axis";

	public static final String ATTR_BACKGROUND = "background";

	public static final String ATTR_BGCOLOR = "bgcolor";

	public static final String ATTR_BORDER = "border";

	public static final String ATTR_CELLPADDING = "cellpadding";

	public static final String ATTR_CELLSPACING = "cellspacing";

	public static final String ATTR_CHAR = "char";

	public static final String ATTR_CHAROFF = "charoff";

	public static final String ATTR_CHARSET = "charset";

	public static final String ATTR_CHECKED = "checked";

	public static final String ATTR_CITE = "cite";

	public static final String ATTR_CLASS = "class";

	public static final String ATTR_CLASSID = "classid";

	public static final String ATTR_CLEAR = "clear";

	public static final String ATTR_CODE = "code";

	public static final String ATTR_CODEBASE = "codebase";

	public static final String ATTR_CODETYPE = "codetype";

	public static final String ATTR_COLOR = "color";

	public static final String ATTR_COLS = "cols";

	public static final String ATTR_COLSPAN = "colspan";

	public static final String ATTR_COMPACT = "compact";

	public static final String ATTR_CONTENT = "content";

	public static final String ATTR_COORDS = "coords";

	public static final String ATTR_DATA = "data";

	public static final String ATTR_DATETIME = "datetime";

	public static final String ATTR_DECLARE = "declare";

	public static final String ATTR_DEFER = "defer";

	public static final String ATTR_DIR = "dir";

	public static final String ATTR_DISABLED = "disabled";

	public static final String ATTR_ENCTYPE = "enctype";

	public static final String ATTR_FACE = "face";

	public static final String ATTR_FOR = "for";

	public static final String ATTR_FRAME = "frame";

	public static final String ATTR_FRAMEBORDER = "frameborder";

	public static final String ATTR_HEADERS = "headers";

	public static final String ATTR_HEIGHT = "height";

	public static final String ATTR_HREF = "href";

	public static final String ATTR_HREFLANG = "hreflang";

	public static final String ATTR_HSPACE = "hspace";

	public static final String ATTR_HTTPEQUIV = "http-equiv";

	public static final String ATTR_ID = "id";

	public static final String ATTR_ISMAP = "ismap";

	public static final String ATTR_LABEL = "label";

	public static final String ATTR_LANG = "lang";

	public static final String ATTR_LANGUAGE = "language";

	public static final String ATTR_LINK = "link";

	public static final String ATTR_LONGDESC = "longdesc";

	public static final String ATTR_MARGINHEIGHT = "marginheight";

	public static final String ATTR_MARGINWIDTH = "marginwidth";

	public static final String ATTR_MAXLENGTH = "maxlength";

	public static final String ATTR_MEDIA = "media";

	public static final String ATTR_METHOD = "method";

	public static final String ATTR_MULTIPLE = "multiple";

	public static final String ATTR_NAME = "name";

	public static final String ATTR_NOHREF = "nohref";

	public static final String ATTR_NORESIZE = "noresize";

	public static final String ATTR_NOSHADE = "noshade";

	public static final String ATTR_NOWRAP = "nowrap";

	public static final String ATTR_OBJECT = "object";

	public static final String ATTR_ONBLUR = "onblur";

	public static final String ATTR_ONCHANGE = "onchange";

	public static final String ATTR_ONCLICK = "onclick";

	public static final String ATTR_ONDBLCLICK = "ondblclick";

	public static final String ATTR_ONFOCUS = "onfocus";

	public static final String ATTR_ONKEYDOWN = "onkeydown";

	public static final String ATTR_ONKEYPRESS = "onkeypress";

	public static final String ATTR_ONKEYUP = "onkeyup";

	public static final String ATTR_ONLOAD = "onload";

	public static final String ATTR_ONMOUSEDOWN = "onmousedown";

	public static final String ATTR_ONMOUSEMOVE = "onmousemove";

	public static final String ATTR_ONMOUSEOUT = "onmouseout";

	public static final String ATTR_ONMOUSEOVER = "onmouseover";

	public static final String ATTR_ONMOUSEUP = "onmouseup";

	public static final String ATTR_ONRESET = "onreset";

	public static final String ATTR_ONSELECT = "onselect";

	public static final String ATTR_ONSUBMIT = "onsubmit";

	public static final String ATTR_ONUNLOAD = "onunload";

	public static final String ATTR_PROFILE = "profile";

	public static final String ATTR_PROMPT = "prompt";

	public static final String ATTR_READONLY = "readonly";

	public static final String ATTR_REL = "rel";

	public static final String ATTR_REV = "rev";

	public static final String ATTR_ROWS = "rows";

	public static final String ATTR_ROWSPAN = "rowspan";

	public static final String ATTR_RULES = "rules";

	public static final String ATTR_SCHEME = "scheme";

	public static final String ATTR_SCOPE = "scope";

	public static final String ATTR_SCROLLING = "scrolling";

	public static final String ATTR_SELECTED = "selected";

	public static final String ATTR_SHAPE = "shape";

	public static final String ATTR_SIZE = "size";

	public static final String ATTR_SPAN = "span";

	public static final String ATTR_SRC = "src";

	public static final String ATTR_STANDBY = "standby";

	public static final String ATTR_START = "start";

	public static final String ATTR_STYLE = "style";

	public static final String ATTR_SUMMARY = "summary";

	public static final String ATTR_TABINDEX = "tabindex";

	public static final String ATTR_TARGET = "target";

	public static final String ATTR_TEXT = "text";

	public static final String ATTR_TITLE = "title";

	public static final String ATTR_TYPE = "type";

	public static final String ATTR_USEMAP = "usemap";

	public static final String ATTR_VALIGN = "valign";

	public static final String ATTR_VALUE = "value";

	public static final String ATTR_VALUETYPE = "valuetype";

	public static final String ATTR_VERSION = "version";

	public static final String ATTR_VLINK = "vlink";

	public static final String ATTR_VSPACE = "vspace";

	public static final String ATTR_WIDTH = "width";

	public static final String TYPE_SUBMIT = "submit";

	public static final String TYPE_CHECKBOX = "checkbox";

	public static final String TYPE_RADIO = "radio";

	public static final String TYPE_IMAGE = "image";

	public static final String TYPE_PASSWORD = "password";

	public static final String TYPE_TEXT = "text";

	public static final String TYPE_HIDDEN = "hidden";

	public static final String SUBMIT_LABEL = "Submit Query";

	public static final String RESET_LABEL = "Reset";
}
