/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationToken;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.XMLAccessible;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible;

public class BPELCorrelationSet
implements Comparator {
    private static final String MAPNAME = "BPEL_CORRELATION_SETS";
    XMLAccessible builder;
    BPELCorrelationToken[] tokens;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPELCorrelationSet getOrCreate(RunnerInterface runner, String name, XMLAccessible builder, BPELCorrelationToken[] tokens) throws Exception {
        HashMap sets;
        HashMap hashMap = sets = runner.getEngineLocalStorageMap(MAPNAME);
        synchronized (hashMap) {
            BPELCorrelationSet set = (BPELCorrelationSet)sets.get(name);
            if (set == null) {
                set = new BPELCorrelationSet(builder, tokens);
                sets.put(name, set);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPELCorrelationSet getOrError(RunnerInterface runner, String name) throws Exception {
        HashMap sets;
        HashMap hashMap = sets = runner.getEngineLocalStorageMap(MAPNAME);
        synchronized (hashMap) {
            BPELCorrelationSet set = (BPELCorrelationSet)sets.get(name);
            if (set == null) {
                throw new Exception("failed to get (and not create) correlation set");
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPELCorrelationSet createOrError(RunnerInterface runner, String name, XMLAccessible builder, BPELCorrelationToken[] tokens) throws Exception {
        HashMap sets;
        HashMap hashMap = sets = runner.getEngineLocalStorageMap(MAPNAME);
        synchronized (hashMap) {
            BPELCorrelationSet set = (BPELCorrelationSet)sets.get(name);
            if (set != null) {
                throw new Exception("failed to create (and not get) correlation set");
            }
            set = new BPELCorrelationSet(builder, tokens);
            sets.put(name, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUninitialised(RunnerInterface runner, String name) throws Exception {
        HashMap sets;
        HashMap hashMap = sets = runner.getEngineLocalStorageMap(MAPNAME);
        synchronized (hashMap) {
            sets.remove(name);
        }
    }

    private BPELCorrelationSet(XMLAccessible builder, BPELCorrelationToken[] tokens) {
        this.builder = builder;
        this.tokens = tokens;
        Arrays.sort(tokens, this);
    }

    public XMLAccessible getObjectBuilder() {
        return this.builder;
    }

    public void merge(BPELCorrelationSet set) {
        BPELCorrelationToken[] ntokens = new BPELCorrelationToken[this.tokens.length + set.tokens.length];
        System.arraycopy(this.tokens, 0, ntokens, 0, this.tokens.length);
        System.arraycopy(set.tokens, 0, ntokens, this.tokens.length, set.tokens.length);
        this.tokens = ntokens;
        Arrays.sort(this.tokens, this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.tokens.length) {
            this.tokens[i].toString(sb);
            ++i;
        }
        return sb.toString();
    }

    public int compare(Object o1, Object o2) {
        BPELCorrelationToken t1 = (BPELCorrelationToken)o1;
        BPELCorrelationToken t2 = (BPELCorrelationToken)o2;
        return t1.getName().compareTo(t2.getName());
    }

    public boolean matches(XPathAccessible match) throws Exception {
        int i = 0;
        while (i < this.tokens.length) {
            if (!this.tokens[i].matches(match)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

