/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StackTracer;

public class Logger {
    public static boolean PRINT_INFO = false;
    public static boolean PRINT_WARNING = true;
    public static boolean PRINT_ERROR = true;
    public static boolean LOG_TO_CLI = true;
    public static boolean LOG_TO_FILE = true;
    public static boolean PRINT_STACKTRACE = true;
    public static boolean GENERATE_STACKTRACE = false;
    private static HashMap log_map = new HashMap();
    private static HashMap mark_map = new HashMap();
    private static Object chelog_lock = new Object();
    private static FileOutputStream chelog = null;
    public static PrintStream stdout = System.out;
    public static PrintStream stderr = System.err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String message) {
        if (LOG_TO_CLI) {
            if (message.charAt(message.length() - 1) != '\n') {
                stderr.println(message);
            } else {
                stderr.print(message);
            }
        }
        if (LOG_TO_FILE) {
            Object object = chelog_lock;
            synchronized (object) {
                try {
                    if (chelog == null) {
                        chelog = new FileOutputStream("b2j.log");
                    }
                    chelog.write(message.getBytes());
                    chelog.write(13);
                    chelog.write(10);
                    chelog.flush();
                }
                catch (Exception exception) {
                    LOG_TO_FILE = false;
                    stderr.println("Unable to open b2j.log (this is probably ok, only Daemon should open it)");
                }
            }
        }
    }

    public static void mark(String textToPrint) {
        if (PRINT_INFO) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            long tmp = 0L;
            try {
                long now = System.currentTimeMillis();
                Long mark = (Long)mark_map.get(thread);
                if (mark == null) {
                    mark = new Long(System.currentTimeMillis());
                }
                tmp = now - mark;
                mark_map.put(thread, new Long(now));
            }
            catch (Exception exception) {}
            String message = "M:(" + thread + "):(" + tmp + "ms):" + caller + ":" + textToPrint + "\n";
            Logger.log(message);
        }
    }

    public static void direct(String textToPrint) {
        String caller = Logger.getCallerStackTrace();
        String thread = Thread.currentThread().getName();
        String message = "D:(" + thread + "):" + caller + ":" + textToPrint + "\n";
        Logger.log(message);
    }

    public static void info(String textToPrint, Throwable t) {
        if (PRINT_INFO) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "I:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (PRINT_STACKTRACE) {
                message = String.valueOf(message) + Logger.getStackTrace(t);
            }
            Logger.log(message);
        }
    }

    public static void info(String textToPrint) {
        if (PRINT_INFO) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "I:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            Logger.log(message);
        }
    }

    public static void warning(String textToPrint, Throwable t) {
        if (PRINT_WARNING) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "W:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (PRINT_STACKTRACE) {
                message = String.valueOf(message) + Logger.getStackTrace(t);
            }
            Logger.log(message);
        }
    }

    public static void warning(String textToPrint) {
        if (PRINT_WARNING) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "W:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            if (GENERATE_STACKTRACE) {
                message = String.valueOf(message) + Logger.getStackTrace();
            }
            Logger.log(message);
        }
    }

    public static void error(String textToPrint, Throwable t) {
        if (PRINT_ERROR) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "E:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (PRINT_STACKTRACE) {
                message = String.valueOf(message) + Logger.getStackTrace(t);
            }
            Logger.log(message);
        }
    }

    public static void error(String textToPrint) {
        if (PRINT_ERROR) {
            String caller = Logger.getCallerStackTrace();
            String thread = Thread.currentThread().getName();
            String message = "E:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            if (GENERATE_STACKTRACE) {
                message = String.valueOf(message) + Logger.getStackTrace();
            }
            Logger.log(message);
        }
    }

    private static String getCallerStackTrace() {
        String ret = StackTracer.getCallerTrace(3);
        if (ret == null) {
            Throwable t = new Throwable();
            ret = Logger.getLineOfStackTrace(t, Logger.getStackTrace(t), 4);
        }
        return ret;
    }

    private static String getLineOfStackTrace(Throwable t, String stackTrace, int lineNumber) {
        int beginIndex = 0;
        int endIndex = 0;
        String cname = t.getClass().getName();
        int lastindex = stackTrace.lastIndexOf(cname);
        lastindex = lastindex == -1 ? 0 : (lastindex += cname.length());
        int index = lastindex;
        int i = 0;
        while (i < lineNumber) {
            beginIndex = index + 5;
            endIndex = stackTrace.charAt((index = stackTrace.indexOf(10, index + 1)) - 1) == '\n' || stackTrace.charAt(index - 1) == '\r' ? index - 1 : index;
            ++i;
        }
        try {
            return stackTrace.substring(beginIndex, endIndex);
        }
        catch (Exception exception) {
            return "unknown-error";
        }
    }

    public static String getOneLineStackTrace(Throwable t) {
        return Logger.getStackTrace(t).replace('\n', '|').replace('\r', ' ');
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String getStackTrace() {
        Throwable t = new Throwable("DEBUGGER GENERATED STACKTRACE");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static void main(String[] args) {
        Logger.testStackTrace();
    }

    public static void testStackTrace() {
        stdout.println(Logger.getStackTrace());
        Logger.direct("CORRECT STACK TRACE?");
    }
}

