/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on Apr 8, 2004
 */
public class TechnologyDefinition implements ITechnologyDefinition, Comparable {

	public static final String ATTR_ID = "id"; //$NON-NLS-1$

	private IConfigurationElement mElement;
	private String mID;

	public TechnologyDefinition(IConfigurationElement element)
			throws PackageExtensionException {
		super();
		init(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ITechnologyDefinition#getID()
	 */
	public String getID() {
		return mID;
	}

	public String toString() {
		return DeployCorePlugin.getDefault().getResourceString(
				"TechnologyDefinition.toString", new Object[] { mID}); //$NON-NLS-1$
	}

	private void init(IConfigurationElement element)
			throws PackageExtensionException {
//		Assert.isTrue(DeploymentExtensionManager.EXT_ELEM_TECHNOLOGY_DEFINITION
//				.equals(element.getName()));

		mElement = element;

		mID = element.getAttribute(ATTR_ID);

		if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
			System.out
					.println(DeployCorePlugin
							.getDefault()
							.getResourceString(
									"TechnologyDefinition.trace.processingTechnologyDefinition", //$NON-NLS-1$
									new Object[] { getID()}));
			System.out.flush();
		}

		if (mID == null) {
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"TechnologyDefinition.exception.technologyDefinitionParseError")); //$NON-NLS-1$
		}
	}

	public int compareTo(Object o) {
		return getID().compareTo(((TechnologyDefinition) o).getID());
	}

	public boolean equals(Object obj) {
		boolean retVal;
		if (obj instanceof TechnologyDefinition) {
			retVal = getID().equals(((TechnologyDefinition) obj).getID());
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	public int hashCode() {
		return mID.hashCode();
	}

}