/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.help;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.ui.PlatformUI;

/**
 * @author rcernich
 * 
 * Created on Feb 18, 2005
 */
public class HelpUtilities {

	public static void displayHelp(String contextID) {
		IContext context = HelpSystem.getContext(contextID);
		if (context == null || context.getRelatedTopics().length == 0
				|| context.getRelatedTopics()[0].getHref() == null) {
			
			PlatformUI.getWorkbench().getHelpSystem().displayHelp();
		}
		else {
			PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(context.getRelatedTopics()[0]
					.getHref());
		}
	}

}