/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class ResourceUtilities {

   private static final IWorkspaceRoot WORKSPACE_ROOT    = ResourcesPlugin
                                                               .getWorkspace()
                                                               .getRoot();

   /**
    * Resource indication in platform protocol. Indicates url is for a resource
    * in the workspace. i.e. "platform:/resource/projectname/..."
    * 
    * @since 1.0.0
    */
   private static final String         PLATFORM_RESOURCE = "resource";    //$NON-NLS-1$

   /**
    * Protocol for platform uri's. i.e. "platform:/..."
    * 
    * @since 1.0.0
    * 
    */
   public static final String          PLATFORM_PROTOCOL = "platform";    //$NON-NLS-1$

   public static IFile getPlatformFile(URI uri) {
      if (isPlatformResourceURI(uri)) {
         String fileString = URI.decode(uri.path());
         fileString = fileString.substring(PLATFORM_RESOURCE.length() + 1);
         IPath filePath = new Path(fileString);
         IResource resource = WORKSPACE_ROOT.findMember(filePath);
         if (resource == null)
            return WORKSPACE_ROOT.getFile(filePath);
         else if (resource.getType() == IResource.FILE)
            return (IFile) resource;
      }
      return null;
   }

   public static boolean isFile(URI uri) {
      if (isPlatformResourceURI(uri)) {
         String fileString = URI.decode(uri.path());
         fileString = fileString.substring(PLATFORM_RESOURCE.length() + 1);
         IResource resource = WORKSPACE_ROOT.findMember(new Path(fileString));
         if (resource == null || resource.getType() == IResource.FILE)
            return true;
      }
      return false;

   }

   /**
    * Does the passed URI have the form platform:/resource/... ?
    * 
    * @param uri
    * @return <code>true</code> if it is a platform resource protocol.
    * 
    * @since 1.0.0
    */
   public static boolean isPlatformResourceURI(URI uri) {
      return PLATFORM_PROTOCOL.equals(uri.scheme())
            && PLATFORM_RESOURCE.equals(uri.segment(0));
   }
}
