/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.resources;

/**
 * Published constants for SCA Model API.
 * 
 * @since 1.0
 * 
 */
public interface SOAConstants {
   /**
    * The extension for *.composite files (without the ".").
    */
   String COMPOSITE_EXT      = "composite";     //$NON-NLS-1$

   /**
    * The extension for *.componentType files (without the ".").
    */
   String COMPONENT_TYPE_EXT = "componentType"; //$NON-NLS-1$

   /**
    * The extension for *.module files (without the ".").
    */
   String MODULE_EXT         = "module";        //$NON-NLS-1$

   String JAVA_INTERFACE     = "JAVA_INTERFACE"; //$NON-NLS-1$	

   String WSDL_PORTYPE       = "WSDL_PORTTYPE"; //$NON-NLS-1$

   /**
    * The type returned from
    * {@link org.eclipse.stp.core.sca.Component#getType()} if the underlying
    * component is a configured SCA module. (SCA *.module file).
    */
   String SCA_MODULE_TYPE    = "sca";           //$NON-NLS-1$
}
