/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;

/**
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * 
 * @since 1.0
 * 
 */
public interface SCAObject {
   /**
    * Return an int for the flags associated with this SOAObject. Use
    * {@link Flags} to test the flags returned as well as constants for the
    * flags.
    * 
    * @see Flags
    * @return int
    */
   int getFlags();

   /**
    * Return an EObject for this SOAObject.
    * 
    * @return EObject
    */
   EObject getEObject();

   /**
    * 
    * @param name
    *           The name of this SCAObject
    */
   void setName(String name);

   /**
    * 
    * @return The name of this SCAObject
    */
   String getName();

   /**
    * A modeled object will not overwrite any existing status unless a client
    * calls {@link #clearStatus()}. Whenever a client calls addStatus(), either
    * a new MultiStatus is created with the parameters of the given status, or
    * the given aNewStatus is added to an existing MultiStatus. The resultant
    * combined MultiStatus is returned.
    * 
    * @param aNewStatus
    *           A status for this model object (could be warning, error, info,
    *           or OK)
    * @return The current status of this SCAObject
    */
   MultiStatus addStatus(IStatus aNewStatus);

   /**
    * Reset the status to just IStatus.OK
    */
   void clearStatus();

   /**
    * Will never return null. If no status has been explicitly set, this method
    * returns Status.OK_STATUS.
    * 
    * @return The current status to indicate if there are known problems with
    *         this model object.
    */
   MultiStatus getStatus();

}
