/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.common.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author jma
 * Utils class to find button, text box...
 * <P>
 * This class is used during unit testing
 */
public class SWTUtils {

    public static Button getDialogButton(Dialog aDialog, String buttonLabel) {
        return getButtonInComposite((Composite) aDialog.buttonBar, buttonLabel);
    }

    public static Button getButtonInComposite(Composite composite, String expectedText) {
        return (Button)getControlInComposite(composite, Button.class.getName(), expectedText);
    }

    public static Label getLabelInComposite(Composite composite, String expectedText) {
        return (Label)getControlInComposite(composite, Label.class.getName(), expectedText);
    }
    
    public static Text getTextInComposite(Composite composite, String expectedText) {
        return (Text)getControlInComposite(composite, Text.class.getName(), expectedText);
    }
    
    public static Text getTextInCompositeByLabel(Composite composite, String expectedLabel) {
        
        for (int i = 0; i < composite.getChildren().length; i++) {
            Control ctl = composite.getChildren()[i];
            if (ctl instanceof Composite) {
                Text ret = getTextInCompositeByLabel((Composite)ctl, expectedLabel);
                if (ret != null) {
                    return ret;
                }
            }
            if (ctl instanceof Label) {
                if (!((Label)ctl).getText().equals(expectedLabel)) {
                    continue;
                }
                
                if (composite.getChildren().length == i + 1) {
                    continue; //no more control
                }
                
                Control txt = composite.getChildren()[i + 1];
                if (txt instanceof Text) {
                    return (Text)txt;
                }
            }
        }
        return null;
    }
        
    public static Control getControlInComposite(Composite composite, String className, String expectedText) {
        Control control = null;
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; i++) {
            Control child = children[i];
            if (child instanceof Composite) {
                control = getControlInComposite((Composite) child, className, expectedText);
            } else {
                control = getMatchingTextControl(child, expectedText);
            }
            if (control != null && control.getClass().getName().equals(className)) {
                return control;
            }
        }
        return null;
    }

    private static Control getMatchingTextControl(Control control, String expectedText) {
        String controlText = getControlText(control);
        if (isMatchingText(controlText, expectedText)) {
            return control;
        }
        return null;
    }

    
    
    public static String getControlText(Control control) {
        if (control instanceof Label) {
            return ((Label)control).getText();
        }
        if (control instanceof Button) {
            return ((Button)control).getText();
        }
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        return null;
    }

    private static boolean isMatchingText(String currentText, String expectedText) {
        return currentText != null && currentText.indexOf(expectedText) != -1;
    }
}
