/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.sync;

/**
 * 
 * @author amiguel
 * 
 * Probably obsolete.
 * 
 * Part of the generic runtime engine API, implements a Barrier synchronization
 * construct which can be shared and accessed by any part of the engine.
 */
public class SharedBarrier {

SharedSemaphore waiting;
SharedSemaphore barrier;
int size;

	public SharedBarrier(SharedSemaphore waiting, SharedSemaphore barrier, int size) {
		this.waiting = waiting;
		this.barrier = barrier;
		this.size = size;
	}

	/**
	 * Wait for this barrier to become full
	 *
	 */
	public void barrierWait() throws Exception {
		waiting.semWait(size);
	}
	
	/**
	 * Release everything queued at this barrier
	 *
	 */
	public void barrierRelease() throws Exception {
		barrier.semSignal(size);
	}

	/**
	 * Queue at this barrier
	 *
	 */	
	public void barrierQueue() throws Exception {
		waiting.semSignal(1);
		barrier.semWait(1);
	}
	
}