/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author amiguel
 * 
 * A class to serve transactions from a TransactionClient.
 *
 * The class immediately starts reading messages upon construction.
 * The user should implement TransactionListener and use the interface to
 * process messages and return the correct response.
 */
public class BasicSTTransactionServer extends Thread implements STTransactionServer {

MessageReader min;
MessageWriter mout;
TransactionListener tl;

/**
 * Construct a new TransactionServer around an input and output stream
 * @param bin the input stream to read messages on
 * @param bout the output stream to write message to
 * @param tl the TransactionListener which will process the transactions
 * @param tg the ThreadGroup to make this TransactionServer thread a part of
 * @param threadname the the thread name to give this thread
 */
public BasicSTTransactionServer(InputStream bin, OutputStream bout, TransactionListener tl, ThreadGroup tg, String threadname) {
	super(tg,threadname);
	min = new MessageReader(bin);
	mout = new MessageWriter(bout);
	this.tl = tl;

	start();	
}//end constructor

/**
 * Construct a new TransactionServer around an input and output stream
 * @param bin the input stream to read messages on
 * @param bout the output stream to write message to
 * @param tl the TransactionListener which will process the transactions
 */
public BasicSTTransactionServer(InputStream bin, OutputStream bout, TransactionListener tl) {
	min = new MessageReader(bin);
	mout = new MessageWriter(bout);
	this.tl = tl;

	start();	
}//end constructor

public void run() {
	
	Message m;
	
	while( true ) {
	
		try { 
		
			m = min.read();
	
			m = tl.doTransaction(m);
	
			mout.write(m);
	
		} catch (IOException e) {
			break;
		}
		
	}//end while
}//end method

}//end class
