/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

/**
 * @author amiguel
 * 
 * This file can be used to add JARs or URLs to the system classloader.
 * This means that Class.forName() and so on will be able to load the classes.
 */
public class ClassPathHacker {

	private static final Class[] parameters = new Class[]{URL.class};

	/**
	 * Add a file to the classpath (e.g. a JAR file or a directory)
	 * @param s the path of the file to add
	 */
	public static void addFile(String s) throws IOException {
		File f = new File(s);
		addFile(f);
	}//end method

	/**
	 * Add a file to the classpath
	 * @param f the File to add
	 */
	public static void addFile(File f) throws IOException {
		addURL(f.toURL());
	}//end method

	/**
	 * Add any URL to the classpath
	 * @param u the URL to add
	 */
	public static void addURL(URL u) throws IOException {
		
		URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
		Class sysclass = URLClassLoader.class;

		try {
			Method method = sysclass.getDeclaredMethod("addURL",parameters);
			method.setAccessible(true);
			method.invoke(sysloader,new Object[]{ u });
		} catch (Throwable t) {
			t.printStackTrace();
			throw new IOException("Error, could not add URL to system classloader");
		}//end try catch
		
	}//end method

	/**
	 * Test method
	 */
	public static void main(String[] args) {

		if (args.length == 0) {
			System.out.println("Usage: ClassPathHacker [-addcp <url>] <class1> <class2> ... <classN>");
			System.exit(0);
		}//end if

		ArrayList classes = new ArrayList();

		for (int i = 0; i < args.length; i++) {
			if (args[i].equalsIgnoreCase("-addcp")) {
				
				try {
					addFile(args[++i]);
					System.out.println("added "+args[i]+" to classpath");
				} catch (IOException e) {
					e.printStackTrace();
				}

			} else {
				
				classes.add(args[i]);
		
			}//end if
		}//end for

		for (int i = 0; i < classes.size(); i++) {	
		
			String cname = (String)classes.get(i);
		
			try {
				Class c = Class.forName(cname);
				System.out.println("CLASS LOADED OK! "+c);
			} catch (Exception e) {
				System.out.println("CLASS LOAD FAILED! "+cname);
			}
			
		}//end for
	
	}

}//end class
