/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

import java.util.Collections;
import java.util.Iterator;

import javax.xml.namespace.NamespaceContext;

import org.w3c.dom.Document;

public class DocumentNamespaceContext implements NamespaceContext {
    private final Document document;

    public DocumentNamespaceContext(Document doc) {
        document = doc;
    }

    public String getNamespaceURI(String prefix) {
        return document.lookupNamespaceURI(prefix);
    }

    public String getPrefix(String uri) {
        return document.lookupPrefix(uri); 
    }

    public Iterator getPrefixes(String uri) {
        return Collections.singleton(getPrefix(uri)).iterator();
    }
}