/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory
 * @model kind="package"
 * @generated
 */
public interface DeployFilePackage extends EPackage {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "deployfile";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/stp/models/deploy/deployfile";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "deployFile";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DeployFilePackage eINSTANCE = org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl
			.init();

	/**
	 * The meta object id for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl <em>Deploy Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployPackage()
	 * @generated
	 */
	int DEPLOY_PACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Target Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_PACKAGE__TARGET_CONFIGURATION = 0;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_PACKAGE__ROOT = 1;

	/**
	 * The feature id for the '<em><b>Package File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_PACKAGE__PACKAGE_FILE = 2;

	/**
	 * The number of structural features of the '<em>Deploy Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_PACKAGE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl <em>Deploy Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployConfiguration()
	 * @generated
	 */
	int DEPLOY_CONFIGURATION = 1;

	/**
	 * The feature id for the '<em><b>Source Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_CONFIGURATION__SOURCE_PACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Target Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_CONFIGURATION__TARGET_SERVER = 1;

	/**
	 * The feature id for the '<em><b>Config Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_CONFIGURATION__CONFIG_OVERRIDE = 2;

	/**
	 * The number of structural features of the '<em>Deploy Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_CONFIGURATION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl <em>Deploy Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployServer()
	 * @generated
	 */
	int DEPLOY_SERVER = 2;

	/**
	 * The feature id for the '<em><b>Targeting Configuration</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_SERVER__TARGETING_CONFIGURATION = 0;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_SERVER__ROOT = 1;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_SERVER__PROFILE_NAME = 2;

	/**
	 * The feature id for the '<em><b>Server Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_SERVER__SERVER_ID = 3;

	/**
	 * The number of structural features of the '<em>Deploy Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPLOY_SERVER_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.RootImpl <em>Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.RootImpl
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getRoot()
	 * @generated
	 */
	int ROOT = 3;

	/**
	 * The feature id for the '<em><b>Package</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__PACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Server</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__SERVER = 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__VERSION = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__NAME = 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__DESCRIPTION = 4;

	/**
	 * The number of structural features of the '<em>Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_FEATURE_COUNT = 5;

	/**
	 * Returns the meta object for class '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage <em>Deploy Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Deploy Package</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage
	 * @generated
	 */
	EClass getDeployPackage();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getTargetConfiguration <em>Target Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target Configuration</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getTargetConfiguration()
	 * @see #getDeployPackage()
	 * @generated
	 */
	EReference getDeployPackage_TargetConfiguration();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getRoot()
	 * @see #getDeployPackage()
	 * @generated
	 */
	EReference getDeployPackage_Root();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getPackageFile <em>Package File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Package File</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getPackageFile()
	 * @see #getDeployPackage()
	 * @generated
	 */
	EAttribute getDeployPackage_PackageFile();

	/**
	 * Returns the meta object for class '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration <em>Deploy Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Deploy Configuration</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration
	 * @generated
	 */
	EClass getDeployConfiguration();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage <em>Source Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Source Package</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage()
	 * @see #getDeployConfiguration()
	 * @generated
	 */
	EReference getDeployConfiguration_SourcePackage();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getTargetServer <em>Target Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Server</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getTargetServer()
	 * @see #getDeployConfiguration()
	 * @generated
	 */
	EReference getDeployConfiguration_TargetServer();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getConfigOverride <em>Config Override</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Config Override</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getConfigOverride()
	 * @see #getDeployConfiguration()
	 * @generated
	 */
	EAttribute getDeployConfiguration_ConfigOverride();

	/**
	 * Returns the meta object for class '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer <em>Deploy Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Deploy Server</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer
	 * @generated
	 */
	EClass getDeployServer();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getTargetingConfiguration <em>Targeting Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Targeting Configuration</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getTargetingConfiguration()
	 * @see #getDeployServer()
	 * @generated
	 */
	EReference getDeployServer_TargetingConfiguration();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getRoot()
	 * @see #getDeployServer()
	 * @generated
	 */
	EReference getDeployServer_Root();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getProfileName <em>Profile Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Profile Name</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getProfileName()
	 * @see #getDeployServer()
	 * @generated
	 */
	EAttribute getDeployServer_ProfileName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getServerId <em>Server Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Server Id</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployServer#getServerId()
	 * @see #getDeployServer()
	 * @generated
	 */
	EAttribute getDeployServer_ServerId();

	/**
	 * Returns the meta object for class '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root <em>Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root
	 * @generated
	 */
	EClass getRoot();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Package</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getPackage()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Package();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getServer <em>Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Server</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getServer()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Server();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getVersion()
	 * @see #getRoot()
	 * @generated
	 */
	EAttribute getRoot_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getName()
	 * @see #getRoot()
	 * @generated
	 */
	EAttribute getRoot_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getDescription()
	 * @see #getRoot()
	 * @generated
	 */
	EAttribute getRoot_Description();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DeployFileFactory getDeployFileFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {

		/**
		 * The meta object literal for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl <em>Deploy Package</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployPackage()
		 * @generated
		 */
		EClass DEPLOY_PACKAGE = eINSTANCE.getDeployPackage();

		/**
		 * The meta object literal for the '<em><b>Target Configuration</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_PACKAGE__TARGET_CONFIGURATION = eINSTANCE
				.getDeployPackage_TargetConfiguration();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_PACKAGE__ROOT = eINSTANCE.getDeployPackage_Root();

		/**
		 * The meta object literal for the '<em><b>Package File</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPLOY_PACKAGE__PACKAGE_FILE = eINSTANCE
				.getDeployPackage_PackageFile();

		/**
		 * The meta object literal for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl <em>Deploy Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployConfigurationImpl
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployConfiguration()
		 * @generated
		 */
		EClass DEPLOY_CONFIGURATION = eINSTANCE.getDeployConfiguration();

		/**
		 * The meta object literal for the '<em><b>Source Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_CONFIGURATION__SOURCE_PACKAGE = eINSTANCE
				.getDeployConfiguration_SourcePackage();

		/**
		 * The meta object literal for the '<em><b>Target Server</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_CONFIGURATION__TARGET_SERVER = eINSTANCE
				.getDeployConfiguration_TargetServer();

		/**
		 * The meta object literal for the '<em><b>Config Override</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPLOY_CONFIGURATION__CONFIG_OVERRIDE = eINSTANCE
				.getDeployConfiguration_ConfigOverride();

		/**
		 * The meta object literal for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl <em>Deploy Server</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getDeployServer()
		 * @generated
		 */
		EClass DEPLOY_SERVER = eINSTANCE.getDeployServer();

		/**
		 * The meta object literal for the '<em><b>Targeting Configuration</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_SERVER__TARGETING_CONFIGURATION = eINSTANCE
				.getDeployServer_TargetingConfiguration();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DEPLOY_SERVER__ROOT = eINSTANCE.getDeployServer_Root();

		/**
		 * The meta object literal for the '<em><b>Profile Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPLOY_SERVER__PROFILE_NAME = eINSTANCE
				.getDeployServer_ProfileName();

		/**
		 * The meta object literal for the '<em><b>Server Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DEPLOY_SERVER__SERVER_ID = eINSTANCE
				.getDeployServer_ServerId();

		/**
		 * The meta object literal for the '{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.RootImpl <em>Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.RootImpl
		 * @see org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployFilePackageImpl#getRoot()
		 * @generated
		 */
		EClass ROOT = eINSTANCE.getRoot();

		/**
		 * The meta object literal for the '<em><b>Package</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__PACKAGE = eINSTANCE.getRoot_Package();

		/**
		 * The meta object literal for the '<em><b>Server</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROOT__SERVER = eINSTANCE.getRoot_Server();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROOT__VERSION = eINSTANCE.getRoot_Version();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROOT__NAME = eINSTANCE.getRoot_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROOT__DESCRIPTION = eINSTANCE.getRoot_Description();

	}

} //DeployFilePackage
