/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

public class BPELVariable {
    private static final String MAPNAME = "BPEL_VARIABLES";
    public static final String PREFIX = "BPV:";
    public static final String LOCK_PREFIX = "BPV_LOCK:";

    public static void lockVariable(RunnerInterface runner, String name) throws Exception {
        SharedMutex mutex = runner.newMutex(LOCK_PREFIX + name);
        mutex.lock();
        if (name.indexOf("loggedOn") != -1 && name.indexOf("SLOCK") != -1) {
            System.out.println("LOCKED VARIABLE " + name + " via MUTEX " + mutex.sem.id);
        }
    }

    public static void releaseVariable(RunnerInterface runner, String name) throws Exception {
        SharedMutex mutex = runner.newMutex(LOCK_PREFIX + name);
        if (name.indexOf("loggedOn") != -1 && name.indexOf("SLOCK") != -1) {
            System.out.println("RELEASING VARIABLE " + name + " via MUTEX " + mutex.sem.id);
        }
        mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createVariable(RunnerInterface runner, String name, Message msg, boolean local) throws Exception {
        if (local) {
            HashMap map;
            HashMap hashMap = map = runner.getEngineLocalStorageMap(MAPNAME);
            synchronized (hashMap) {
                if (!map.containsKey(name)) {
                    SharedVariable var = new SharedVariable(null, name, -1, 6, msg);
                    map.put(name, var);
                }
            }
        } else {
            BPELVariable.createVariable(runner, name, msg);
        }
    }

    public static void createVariable(RunnerInterface runner, String name, Message msg) throws Exception {
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipushStack("BPELVariable createVariable");
        }
        SharedVariable var = runner.newVariable(PREFIX + name, 6, true);
        var.setValue(msg);
        var.varStore();
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipopStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessage(RunnerInterface runner, String varname, Message msg) throws Exception {
        SharedVariable var;
        HashMap map = runner.getEngineLocalStorageMap(MAPNAME);
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipushStack("BPELVariable setMessage");
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            var = (SharedVariable)map.get(varname);
        }
        if (var != null) {
            var.setValue(msg);
        } else {
            var = runner.getVariable(PREFIX + varname);
            var.setValue(msg);
            var.varStore();
        }
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipopStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message getMessage(RunnerInterface runner, String varname) throws Exception {
        SharedVariable var;
        HashMap map = runner.getEngineLocalStorageMap(MAPNAME);
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipushStack("BPELVariable getMessage");
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            var = (SharedVariable)map.get(varname);
        }
        if (var != null) {
            if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
                runner.ipopStack();
            }
            return (Message)var.getValue();
        }
        var = runner.getVariable(PREFIX + varname);
        var.varFetch();
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipopStack();
        }
        return (Message)var.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedVariable getReference(RunnerInterface runner, String varname) throws Exception {
        SharedVariable var;
        HashMap map = runner.getEngineLocalStorageMap(MAPNAME);
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipushStack("BPELVariable getReference");
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            var = (SharedVariable)map.get(varname);
        }
        if (var == null) {
            var = runner.getVariable(PREFIX + varname);
        }
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipopStack();
        }
        return var;
    }

    public static Message getMessageFromRef(RunnerInterface runner, SharedVariable var) throws Exception {
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipushStack("BPELVariable getReference");
        }
        var.varFetch();
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            runner.ipopStack();
        }
        return (Message)var.getValue();
    }
}

